/*
*   Author: Scott Bailey
*   License: BSD
*   
*   Purpose: Compatibility for 8.3 and below
*/

CREATE OR REPLACE FUNCTION unnest(anyarray)
RETURNS SETOF anyelement AS
$$
    SELECT $1[i] FROM
    generate_series(array_lower($1,1), array_upper($1,1)) i;
$$ LANGUAGE 'sql' IMMUTABLE STRICT;


CREATE AGGREGATE array_agg(anyelement) (
  SFUNC=array_append,
  STYPE=anyarray,
  INITCOND='{}'
);