--
-- reorg_drop()
--
BEGIN;

CREATE SCHEMA reorg_test;
CREATE SCHEMA """reorg"" _ ""test""";

-- relname pattern
CREATE TABLE tbl (col int primary key);
CREATE TABLE reorg_test.tbl (col int primary key);
CREATE TABLE reorg_test."t b l" (col int primary key);
CREATE TABLE """reorg"" _ ""test""".tbl (col int primary key);
CREATE TABLE """reorg"" _ ""test"""." " (col int primary key);
CREATE TABLE """reorg"" _ ""test"""."""" (col int primary key);
CREATE TABLE """reorg"" _ ""test"""."""tbl"" " (col int primary key);
-- temp object not exists
CREATE TABLE tbl_none_obj (col int primary key);

COMMIT;

-- create temp objects
\! ./sql/create_objects.sh 'tbl'
\! ./sql/create_objects.sh 'reorg_test.tbl'
\! ./sql/create_objects.sh 'reorg_test."t b l"'
\! ./sql/create_objects.sh '"""reorg"" _ ""test""".tbl'
\! ./sql/create_objects.sh '"""reorg"" _ ""test"""." "'
\! ./sql/create_objects.sh '"""reorg"" _ ""test""".""""'
\! ./sql/create_objects.sh '"""reorg"" _ ""test"""."""tbl"" "'

-- trigger list
PREPARE trigger_list AS
SELECT R.oid::regclass, T.tgname
FROM pg_trigger T
	LEFT JOIN pg_class R ON R.oid = T.tgrelid
WHERE T.tgname = 'z_reorg_trigger';

-- pk_type list
PREPARE pk_type_list AS
SELECT typname FROM pg_type
WHERE typname LIKE 'pk__%'
	AND typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = 'reorg');

-- temp table list
PREPARE temp_table_list AS
SELECT oid::regclass FROM pg_class
WHERE relname LIKE 'table__%'
	AND relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = 'reorg');

-- log table list
PREPARE log_table_list AS
SELECT oid::regclass FROM pg_class
WHERE relname LIKE 'log__%'
	AND relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = 'reorg');

-- before
EXECUTE trigger_list;
EXECUTE pk_type_list;
EXECUTE temp_table_list;
EXECUTE log_table_list;

-- execute reorg_drop()
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'reorg_test.tbl'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'reorg_test."t b l"'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test""".tbl'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test"""." "'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test""".""""'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test"""."""tbl"" "'::regclass));
SELECT reorg.reorg_drop((SELECT oid FROM pg_class WHERE oid = 'tbl_none_obj'::regclass));

-- after
EXECUTE trigger_list;
EXECUTE pk_type_list;
EXECUTE temp_table_list;
EXECUTE log_table_list;

-- clean up
DROP TABLE IF EXISTS tbl;
DROP TABLE IF EXISTS reorg_test.tbl;
DROP TABLE IF EXISTS reorg_test."t b l";
DROP TABLE IF EXISTS """reorg"" _ ""test""".tbl;
DROP TABLE IF EXISTS """reorg"" _ ""test"""." ";
DROP TABLE IF EXISTS """reorg"" _ ""test"""."""";
DROP TABLE IF EXISTS """reorg"" _ ""test"""."""tbl"" ";
DROP TABLE IF EXISTS tbl_none_obj;

DROP SCHEMA IF EXISTS reorg_test CASCADE;
DROP SCHEMA IF EXISTS """reorg"" _ ""test""" CASCADE;
