CREATE TABLE foo(a integer, b integer);

-- set of basic statements test - if, leave, case, ..
-- leave cycle
CREATE OR REPLACE FUNCTION fx(b int)
RETURNS int as
$$
#option dump
  BEGIN
    DECLARE s int DEFAULT -5;
    lc:
    LOOP
      IF b > 0 THEN
        LEAVE lc;
      END IF;
      SET b = b - 1;
      SET s = s + b;
    END LOOP;
    RETURN b;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);

-- searched case statement                                                                                 
CREATE OR REPLACE FUNCTION fx(b int)
RETURNS int as
$$
#option dump
  BEGIN
    CASE WHEN b = 1 THEN PRINT 'one';
         WHEN b = 2 THEN PRINT 'two';
         ELSE PRINT 'other number';
              PRINT 'than one or two';
    END CASE;
    RETURN b;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(1);
SELECT fx(2);
SELECT fx(10);

-- simple case statement and exception '20000'                                                                 
CREATE OR REPLACE FUNCTION fx(b numeric)
RETURNS numeric as
$$
#option dump
  BEGIN
    CASE b
         WHEN 1.0, 3  , 5.0 THEN PRINT 'odd';  PRINT 'number';
         WHEN 2  , 4.0, 6   THEN PRINT 'even'; PRINT 'number';
    END CASE;
    RETURN b;
  END;
$$ LANGUAGE plpgpsm;

SELECT fx(1.0);
SELECT fx(2.0);
SELECT fx(10.0);

CREATE OR REPLACE FUNCTION fr(OUT a int) 
AS
$$
  SET a = 10;
$$ LANGUAGE plpgpsm;
SELECT fr();

-- assignment result of select
CREATE OR REPLACE FUNCTION fx(b int) 
RETURNS int AS
$$
  BEGIN
    SET b = (SELECT 4);
    RETURN b;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);

-- multiple variable assignment (simultaneous assignment)
CREATE OR REPLACE FUNCTION fx(b int) 
RETURNS int AS 
$$ 
#option dump
  BEGIN 
    DECLARE x, y integer; 
    DECLARE z integer DEFAULT 0;
    SET (x,y)=(10,20); 
    PRINT x,y,z; 
    -- DB2 form of simultaneous assignment
    SET x = 0, y = x + 1, z = y + 1;
    PRINT x,y,z;
    RETURN b; 
  END 
$$ LANGUAGE plpgpsm;
SELECT fx(10);

-- repeat
CREATE OR REPLACE FUNCTION fx(int) 
RETURNS int AS
$$
#option dump
  BEGIN
    DECLARE i integer DEFAULT 0;
    REPEAT
      SET i = i + 1;
      PRINT i;
    UNTIL i < 10
    END REPEAT;
    RETURN i;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);


-- test contine and exit handler for exception
CREATE OR REPLACE FUNCTION fx() RETURNS void AS $$
BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '03001' PRINT '03001 handled';
  DECLARE EXIT HANDLER FOR SQLSTATE '03002' PRINT '03002 handled';
  PRINT 'start';
  DELETE FROM foo;
  INSERT INTO foo VALUES(13,20);
  SIGNAL SQLSTATE '03001';
  INSERT INTO foo VALUES(33,40);
  SIGNAL SQLSTATE '03002';
  PRINT 'finish';
END;
$$ LANGUAGE plpgpsm;
SELECT fx();
SELECT * FROM foo;


-- test contine and exit handler for warnings
CREATE OR REPLACE FUNCTION fx() RETURNS void AS $$
BEGIN
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02001' PRINT '02001 handled';
  DECLARE EXIT HANDLER FOR SQLSTATE '02002' PRINT '02002 handled';
  PRINT 'start';
  -- ignore unhandled warnings
  SIGNAL SQLSTATE '02003';
  DELETE FROM foo;
  INSERT INTO foo VALUES(13,20);
  SIGNAL SQLSTATE '02001';
  INSERT INTO foo VALUES(33,40);
  SIGNAL SQLSTATE '02002';
  PRINT 'finish';
END;
$$ LANGUAGE plpgpsm;
SELECT fx();
SELECT * FROM foo;


-- using cursor and clasic pattern with continue not found handler
CREATE OR REPLACE FUNCTION fx(a int)
RETURNS int AS
$$
#option dump
  BEGIN
      DECLARE done bool DEFAULT false;
      DECLARE aux int;
      DECLARE cx CURSOR FOR
          SELECT Foo.a FROM Foo;
      DECLARE CONTINUE HANDLER FOR NOT FOUND
          SET done = true;
      OPEN cx;
      FETCH cx INTO aux;
      sl:
      WHILE NOT done DO
          SET a = a + aux;
          PRINT fx.a, aux;
          FETCH cx INTO aux;
      END WHILE sl;
      CLOSE cx;
      RETURN a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);


-- cycle controled by SQLSTATE variable
CREATE OR REPLACE FUNCTION fx(a int)
RETURNS int AS
$$
#option dump
  BEGIN
    DECLARE aux int;
    DECLARE SQLSTATE char(5);

    DECLARE cx CURSOR FOR
       SELECT * FROM Foo;

    OPEN cx;

    FETCH cx INTO aux;
    WHILE SQLSTATE = '00000' DO
      SET a = a + aux;
      PRINT fx.a, aux;
      FETCH cx INTO aux;
    END WHILE;

    CLOSE cx;
    RETURN a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);

CREATE OR REPLACE FUNCTION fx(a int)
RETURNS int AS
$$
#option dump
  BEGIN
    DECLARE x, y integer;
    DECLARE SQLSTATE char(5);

    DECLARE cx CURSOR FOR
       SELECT * FROM Foo WHERE Foo.a = fx.a;

    OPEN cx;

    FETCH cx INTO x, y;
    WHILE SQLSTATE = '00000' DO
      PRINT x, y;
      FETCH cx INTO x, y;
    END WHILE;

    CLOSE cx;
    RETURN a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(13);

-- dynamic cursor
CREATE OR REPLACE FUNCTION fx(a int)
RETURNS int AS
$$
#option dump
  BEGIN
    DECLARE x, y integer;
    DECLARE SQLSTATE char(5);

    DECLARE cx CURSOR FOR prepstmt;

    PREPARE prepstmt(int) FROM 'SELECT a*100, b*100 FROM Foo WHERE Foo.a = $1';

    OPEN cx USING a;

    FETCH cx INTO x, y;
    WHILE SQLSTATE = '00000' DO
      PRINT x, y;
      FETCH cx INTO x, y;
    END WHILE;

    CLOSE cx;
    RETURN a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(13);


INSERT INTO Foo VALUES(55,56);

-- for statement
CREATE OR REPLACE FUNCTION fxv(a int)
RETURNS void as 
$$
  FOR SELECT * FROM Foo DO
    PRINT a, b;
  END FOR;
$$ LANGUAGE plpgpsm;
SELECT fxv(10);


-- not found handling
CREATE OR REPLACE FUNCTION fx(b int)
RETURNS int as
$$
#option dump
  BEGIN
    DECLARE c int;
    DECLARE CONTINUE HANDLER FOR NOT FOUND PRINT 'not found'; 
    DELETE FROM foo;                                                                                     
    SELECT INTO b a FROM foo;
    RETURN b+c;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx(10);


-- dynamic execution
DROP FUNCTION fx();
CREATE OR REPLACE FUNCTION fx() 
RETURNS int AS 
$$
#option dump
  BEGIN 
    DECLARE a,b int;
    EXECUTE IMMEDIATE 'SELECT 10,20' INTO a,b; 
    PRINT a,b; 
    RETURN a+b; 
  END; 
$$ LANGUAGE plpgpsm;
SELECT fx();


CREATE OR REPLACE FUNCTION fxx(a int)
RETURNS float AS 
$$
#option dump
  BEGIN
    DECLARE f float;
    PREPARE prep(float) from 'select $1';
    EXECUTE prep INTO f USING a; 
    RETURN f ;
  END;
$$ LANGUAGE plpgpsm;
SELECT fxx(13);


-- embeded SQL
CREATE OR REPLACE FUNCTION fx() 
RETURNS int AS 
$$ 
#option dump
  BEGIN
    DECLARE i int DEFAULT 0; 
    WHILE i < 10 
    DO 
      INSERT INTO foo VALUES(i, i+1); 
      SET i = i + 1; 
    END WHILE; 
    RETURN i; 
  END; 
$$ LANGUAGE plpgpsm;
SELECT fx();

-- function namespace
CREATE OR REPLACE FUNCTION fx(a int, b int)
RETURNS void AS
$$
  FOR f AS 
      SELECT * 
         FROM Foo 
        WHERE Foo.a = fx.a AND Foo.b = Fx.b
  DO 
    PRINT f.a, f.b;
  END FOR;
$$ LANGUAGE plpgpsm;
SELECT fx(3,4);


CREATE OR REPLACE FUNCTION fx(OUT a int)  AS
$$
#option dump
  SELECT INTO a sum(Foo.a)
    FROM Foo;
$$ LANGUAGE plpgpsm;
SELECT fx();


-- signaling user exception completly parametrized
CREATE OR REPLACE FUNCTION fx()
RETURNS int AS 
$$
#option dump
  BEGIN
    SIGNAL SQLSTATE VALUE '11111' 
      SET MESSAGE_TEXT = 'Pavel Stehule',
          PG_MESSAGE_DETAIL       = 'a bydlim ve Skalici',
          PG_MESSAGE_HINT         = 'obcas take nekde jinde';
    RETURN 1;
 END;
$$ LANGUAGE plpgpsm;
SELECT fx();

-- signaling exception via conditional's name
CREATE OR REPLACE FUNCTION fx()
RETURNS int AS 
$$
  BEGIN
    DECLARE my_condition CONDITION FOR SQLSTATE VALUE '00001';
    SIGNAL my_condition;
    RETURN 1;
  END;
$$ LANGUAGE plpgpsm;
SELECT fx();

-- using SQLSTATE variable
CREATE OR REPLACE FUNCTION fog() 
RETURNS void AS 
$$
#option dump
  BEGIN ATOMIC
    DECLARE SQLSTATE char(5);
    DECLARE CONTINUE HANDLER FOR NOT FOUND PRINT 'Not found', SQLSTATE;
    DECLARE UNDO HANDLER FOR SQLSTATE '33333' PRINT '33333 handled', SQLSTATE;
    SIGNAL SQLSTATE '02002';
    PRINT SQLSTATE;
    -- test UNDO handler
    DELETE FROM Foo;
    SIGNAL SQLSTATE '33333';
    PRINT SQLSTATE; -- no sence
  END;
$$ LANGUAGE plpgpsm;
SELECT fog();
SELECT * FROM Foo;

-- next sample of SQLSTATE
CREATE OR REPLACE FUNCTION fos(OUT SQLSTATE char(5)) AS 
$$
  SIGNAL SQLSTATE '02005';
$$ LANGUAGE plpgpsm;
SELECT fos();


-- order specific handler (SQLSTATE, SQLCLASS) before and general handler
CREATE OR REPLACE FUNCTION fov()
RETURNS void AS
$$
  BEGIN
    DECLARE sqlstate char(5);
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION PRINT 'any sql exception', sqlstate;
    DECLARE CONTINUE HANDLER FOR SQLSTATE '33000' PRINT 'class 33', sqlstate;
    DECLARE CONTINUE HANDLER FOR SQLSTATE '33001' 
            BEGIN 
              PRINT 'exact sqlstate 33001';
              INSERT INTO Foo VALUES(46,56); 
            END;
    DELETE FROM Foo;
    INSERT INTO Foo VALUES(44,55);
    SIGNAL SQLSTATE '33001';
    PRINT '33 class';
    SIGNAL SQLSTATE '33002';
    PRINT '44444 Other';
    SIGNAL SQLSTATE '44444';
    -- test continue handler
    PRINT 'finish';
  END;
$$ LANGUAGE plpgpsm;
SELECT fov();
SELECT * FROM Foo;

CREATE OR REPLACE FUNCTION te(OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
#option dump
  RETURN
    TABLE(SELECT * FROM Foo); 
$$ LANGUAGE plpgpsm;
SELECT * FROM te();

-- using recompile option
CREATE OR REPLACE FUNCTION rf()
RETURNS VOID AS
$$
  BEGIN
    DROP TABLE Foo CASCADE;
    CREATE TABLE Foo(a integer, b integer);
    INSERT INTO Foo
       SELECT a, b
      FROM generate_series(1,5) a(a), generate_series(1,5) b(b);
  END;
$$ LANGUAGE plpgpsm;

SELECT rf();
SELECT * FROM Foo;

SELECT rf();
SELECT * FROM Foo;

-- holdable dynamic cursor
CREATE OR REPLACE FUNCTION fxa(a integer) 
RETURNS refcursor AS
$$
  BEGIN
    DECLARE cx CURSOR WITH HOLD FOR prepname;

    PREPARE prepname(int) 
       FROM 'SELECT * FROM Foo WHERE a = $1';

    OPEN cx USING a;
    RETURN cx;
  END;
$$ LANGUAGE plpgpsm;

BEGIN;
  SELECT fxa(3);
  FETCH cx;
  CLOSE cx;
  SELECT fxa(3);
  FETCH cx;
COMMIT;

-- enhanced get diagnostics statement
CREATE OR REPLACE FUNCTION cc()
RETURNS void AS 
$$
  BEGIN
    DECLARE frk CONDITION;
    DECLARE brk CONDITION;
    DECLARE x, y, z text;
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION
      BEGIN
        GET STACKED DIAGNOSTICS x = CONDITION_IDENTIFIER, y = RETURNED_SQLSTATE;
        GET STACKED DIAGNOSTICS CONDITION 1 z = MESSAGE_TEXT;
        PRINT 'handler >', x,',', y,',', z;
        GET DIAGNOSTICS x = CONDITION_IDENTIFIER, y = RETURNED_SQLSTATE, z = MESSAGE_TEXT;
	PRINT 'handler >', x,',', y,',', z;
      END;
    PRINT 'start';
    SIGNAL frk;
    SIGNAL SQLSTATE '33333' SET MESSAGE_TEXT = 'err message';
    PRINT 'finish';
  END;
$$ LANGUAGE plpgpsm;
SELECT cc();

-- resignal statement
CREATE OR REPLACE FUNCTION cc()
RETURNS void AS 
$$
  BEGIN
    DECLARE frk CONDITION;
    DECLARE brk CONDITION;
    DECLARE x, y, z text;
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION
      BEGIN
        GET STACKED DIAGNOSTICS x = CONDITION_IDENTIFIER, y = RETURNED_SQLSTATE;
        GET STACKED DIAGNOSTICS CONDITION 1 z = MESSAGE_TEXT;
        PRINT 'handler >', x,',', y,',', z;
        GET DIAGNOSTICS x = CONDITION_IDENTIFIER, y = RETURNED_SQLSTATE, z = MESSAGE_TEXT;
	PRINT 'handler >', x,',', y,',', z;
	RESIGNAL SET PG_MESSAGE_DETAIL = 'any detail';
      END;
    PRINT 'start';
    SIGNAL frk;
    SIGNAL SQLSTATE '33333' SET MESSAGE_TEXT = 'err message';
    PRINT 'finish';
  END;
$$ LANGUAGE plpgpsm;
SELECT cc();

DELETE FROM Foo;
CREATE OR REPLACE FUNCTION te(OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
  RETURN 
    VALUES(12, 13), (16, 17);
$$ LANGUAGE plpgpsm;
INSERT INTO Foo SELECT * FROM te();

CREATE OR REPLACE FUNCTION te(OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
  VALUES(19, 20), (21, 22);
$$ LANGUAGE plpgpsm;
INSERT INTO Foo SELECT * FROM te();

CREATE OR REPLACE FUNCTION te(OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
  INSERT INTO Foo
    SELECT * 
       FROM Foo
      WHERE Foo.a < 20
      RETURNING *;
$$ LANGUAGE plpgpsm;
SELECT * FROM te();

CREATE OR REPLACE FUNCTION te(c int, OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
  SELECT * 
     FROM Foo
    WHERE Foo.a < c ORDER BY Foo.a;
$$ LANGUAGE plpgpsm;
SELECT * FROM te(18);

CREATE OR REPLACE FUNCTION te(OUT a int, OUT b int)
RETURNS SETOF RECORD AS 
$$
#option dump
  RETURN
    TABLE(SELECT * FROM Foo); 
$$ LANGUAGE plpgpsm;
SELECT * FROM te();

-- multiple variable assignment (simultaneous assignment)
DROP FUNCTION fx(int);
CREATE OR REPLACE FUNCTION fx(b int)
RETURNS int AS
$$
#option dump 
  BEGIN
    DECLARE x, y integer;
    DECLARE z integer DEFAULT 0;
    SET (x,y)=(10,20);
    PRINT x,y,z;
    SET (x,y,z) = (SELECT x+1,y+1, x+y);
    PRINT x,y,z;
    RETURN b;
  END
$$ LANGUAGE plpgpsm;
SELECT fx(10);

-- corect behave for domains
CREATE DOMAIN pos_int AS int CHECK(value > 0) NOT NULL;
CREATE OR REPLACE FUNCTION fx(a pos_int)
RETURNS int AS
$$
  BEGIN
    DECLARE p pos_int;
    SET p = a - 1;
    RETURN p - 1;
  END;
$$ LANGUAGE plpgpsm;
--should fail not null domain
SELECT fx(10::pos_int);

CREATE OR REPLACE FUNCTION fx(a pos_int)
RETURNS int AS
$$
  BEGIN
    DECLARE p pos_int DEFAULT 1;
    SET p = a - 1;
    RETURN p - 1;
  END;
$$ LANGUAGE plpgpsm;

SELECT fx(3::pos_int);

-- should fail 
SELECT fx(1::pos_int);
SELECT fx(0::pos_int);

-- scrollable cursor support
DROP FUNCTION fx();
CREATE OR REPLACE FUNCTION fx()
RETURNS void AS
$$
  BEGIN
    DECLARE x, y integer;
    DECLARE c SCROLL CURSOR FOR 
      SELECT * FROM generate_series(1,2)a(i1), generate_series(1,2)b(i2) order by i1,i2;
    OPEN c;
    FETCH ABSOLUTE -1 FROM c INTO x, y;
    PRINT x, y;
    FETCH RELATIVE -1 FROM c INTO x, y;
    PRINT x, y;
    FETCH RELATIVE -1 FROM c INTO x, y;
    PRINT x, y;
    CLOSE c;
    END;
$$ LANGUAGE plpgpsm;
SELECT fx();

DROP FUNCTION fx();     
-- dynamic scrollable cursor support
CREATE OR REPLACE FUNCTION fx(a int)
RETURNS int AS
$$
  BEGIN
  DECLARE x, y integer;
  DECLARE SQLSTATE char(5);
  DECLARE cx SCROLL CURSOR FOR prepstmt;
  PREPARE prepstmt(int) FROM 'SELECT * FROM generate_series(1,10) a(i),generate_series(1,5) b(i) WHERE b.i = $1 ORDER BY a.i';
  OPEN cx USING a;
  FETCH ABSOLUTE -1 FROM cx INTO x, y;
  WHILE SQLSTATE = '00000' DO
    PRINT x, y;
    FETCH RELATIVE -1 FROM cx INTO x, y;
  END WHILE;
  CLOSE cx;
  RETURN a;
END;
$$ LANGUAGE plpgpsm;
SELECT fx(2);

DROP FUNCTION fx(int);
-- move statement
CREATE OR REPLACE FUNCTION report()
RETURNS void AS 
$$
  bl:BEGIN
      DECLARE done boolean DEFAULT false;
      DECLARE c integer DEFAULT 0;
      DECLARE cx CURSOR FOR SELECT i, i+1 FROM generate_series(1,4) al(i);
      DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = true;
      OPEN cx;
      MOVE cx;
      WHILE NOT done
      DO
        PRINT c;
	SET c = c + 1;
        MOVE cx;
      END WHILE;
      CLOSE cx;
    END bl;
$$ LANGUAGE plpgpsm;
SELECT report();

DROP FUNCTION report();

-- table function support
CREATE OR REPLACE FUNCTION frs(integer) RETURNS SETOF integer AS 
$$
  RETURN TABLE(SELECT * FROM generate_series(2,$1));
$$ LANGUAGE plpgpsm;
SELECT * FROM frs(3);
DROP FUNCTION frs(integer);

-- using qualified function parameters
CREATE OR REPLACE FUNCTION fx(a integer, OUT b integer) AS
$$
  SET fx.b = fx.a;
$$ LANGUAGE plpgpsm;
SELECT fx(22);
DROP FUNCTION fx(integer);
DROP TABLE foo CASCADE;
DROP DOMAIN pos_int CASCADE;

-- using nullable composite types
CREATE TYPE xx AS (a integer, b integer);
CREATE OR REPLACE FUNCTION fxx()
RETURNS void AS 
$$
  BEGIN
    DECLARE a xx;
    IF a IS NULL THEN PRINT 'is null'; END IF;
    SET a = row();
    SET a.a = 10, a.b = 20;
    PRINT a;
    SET a = NULL;
    PRINT a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fxx();

DROP FUNCTION fxx();

-- cannot use empty composite value
CREATE OR REPLACE FUNCTION fxx()
RETURNS void AS
$$ 
  BEGIN
    DECLARE a xx;
    PRINT a.a;
  END;
$$ LANGUAGE plpgpsm;
SELECT fxx();
DROP FUNCTION fxx();

DROP TYPE xx;
