/***************************************************************************
 *  Copyright (C) 2009 Nippon Telegraph and Telephone Corporation
 ***************************************************************************/
/*
 * target_db_message.h
 */
/**
 * @file    target_db_message.h
 * @brief   Messages in stored procedure for using monitoring target DB. 
 *
 *   If you add new logic or function to targetdb.c, please add appropriate
 *   messages to following too,
 *
 */
#ifndef TARGET_DB_MESSAGE_H
#define TARGET_DB_MESSAGE_H

/* Normal message */
#define MSG_TARGET_DB_0001  "%s: start to get autovacuum info of '%s'"
#define MSG_TARGET_DB_0002  "%s: start to get checkpoint info"
#define MSG_TARGET_DB_0003  "%s: start to get system info"

/* Error message */
#define MSG_TARGET_DB_1001  "%s: could not open file '%s': %m"
#define MSG_TARGET_DB_1002  "%s: could not read file '%s': %m"
#define MSG_TARGET_DB_1003  "%s: SPI_connect failed (return code:%d)"
#define MSG_TARGET_DB_1004  "%s: failed on getting system info by uname-command: %s"
#define MSG_TARGET_DB_1005  "%s: could not get data_directory location"
#define MSG_TARGET_DB_1006  "%s: could not delete file '%s': %m"
#define MSG_TARGET_DB_1007  "%s: invalid column number record in '%s'. (line: %d)"
#define MSG_TARGET_DB_1008  "%s: could not write file '%s': %m"


#endif   /* TARGET_DB_MESSAGE_H */

