/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.servlet.fileset.FileSetRequestHandler;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSetPostHandler
implements RequestHandler {
    private final Gson gson = new GsonBuilder().create();
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final CapturedBrowsers capturedBrowsers;
    private final List<FileSetRequestHandler<?>> handlers;

    @Inject
    public FileSetPostHandler(HttpServletRequest request, HttpServletResponse response, CapturedBrowsers capturedBrowsers, List<FileSetRequestHandler<?>> handlers) {
        this.request = request;
        this.response = response;
        this.capturedBrowsers = capturedBrowsers;
        this.handlers = handlers;
    }

    @Override
    public void handleIt() throws IOException {
        FileSetRequestHandler<?> handler = this.handlerFromAction(this.request);
        this.response.getOutputStream().print(this.gson.toJson(handler.handle(this.browserFromId(this.request.getParameter("id")), this.request.getParameter("data"))));
    }

    private SlaveBrowser browserFromId(String id) {
        if (id == null) {
            return null;
        }
        return this.capturedBrowsers.getBrowser(id);
    }

    private FileSetRequestHandler<?> handlerFromAction(HttpServletRequest req) {
        String action = req.getParameter("action");
        for (FileSetRequestHandler<?> handler : this.handlers) {
            if (!handler.canHandle(action)) continue;
            return handler;
        }
        throw new IllegalArgumentException("unknown action");
    }
}

