/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.model.RunDataFactory;
import com.google.jstestdriver.util.StopWatch;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRunner {
    private static final Logger stopWatchLogger = LoggerFactory.getLogger(StopWatch.class);
    private static final Logger logger = LoggerFactory.getLogger(ActionRunner.class);
    private final List<Action> actions;
    private final StopWatch stopWatch;
    private final RunDataFactory factory;

    @Inject
    public ActionRunner(List<Action> actions, StopWatch stopWatch, RunDataFactory factory) {
        this.actions = actions;
        this.stopWatch = stopWatch;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActions() {
        RunData runData = this.factory.get();
        logger.info("TestCases {}", runData.getTestCases().size());
        if (logger.isDebugEnabled()) {
            for (JstdTestCase testCase : runData.getTestCases()) {
                if (testCase.getTests().size() != 1) continue;
                logger.debug("{}:\n{}", (Object)testCase.getTests().get(0).getDisplayPath(), Lists.transform(testCase.getDependencies(), new Function<FileInfo, String>(){

                    @Override
                    public String apply(FileInfo f) {
                        return f.getDisplayPath() + "\n";
                    }
                }));
            }
        }
        Iterator<Action> iterator = this.actions.iterator();
        this.stopWatch.start("runActions", new Object[0]);
        try {
            while (iterator.hasNext()) {
                Action action = iterator.next();
                this.stopWatch.start(action.toString(), new Object[0]);
                logger.info("Running {}", action);
                try {
                    runData = action.run(runData);
                }
                finally {
                    logger.info("Finished {}", action);
                    this.stopWatch.stop(action.toString(), new Object[0]);
                }
            }
        }
        finally {
            try {
                this.stopWatch.stop("runActions", new Object[0]);
                StringWriter writer = new StringWriter();
                this.stopWatch.print(writer);
                ((Writer)writer).flush();
                stopWatchLogger.info(((Object)writer).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

