<?xml version="1.0" encoding="utf-8" ?>
<!-- Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<xsl:template match="/"> 
  <html>
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <title>Index of <xsl:value-of select="dir/@path" /></title>
      <link rel="stylesheet" type="text/css" href="/css/style.css" />
    </head>
    <body>
      <h1>Index of /<xsl:value-of select="dir/@path" /></h1>
      <table>
        <thead>
          <tr>
            <th>File name</th>
            <th>Size</th>
            <th>Last Update</th>
          </tr>
        </thead>
        <tbody>
          <xsl:apply-templates select="dir/*" />
        </tbody>
      </table>
    </body>
  </html>
</xsl:template>

<xsl:template match="file">
  <tr>
    <td><a href="/{/dir/@path}/{name}"><xsl:value-of select="name" /></a></td>
    <xsl:choose>
      <xsl:when test="boolean(size)">
        <td align="right"><xsl:value-of select="size" /></td>
      </xsl:when>
      <xsl:otherwise>
        <td align="center">-</td>
      </xsl:otherwise>
    </xsl:choose>
    <td><xsl:value-of select="mtime" /></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
