//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsNot.cpp,v 1.1 2008/06/27 18:19:16 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#include "pgAdmin3.h"
#include "pgscript/expressions/pgsNot.h"

#include "pgscript/objects/pgsVariable.h"

pgsNot::pgsNot(const pgsExpression * left) :
	pgsOperation(left, 0)
{
	
}

pgsNot::~pgsNot()
{
	
}

pgsExpression * pgsNot::clone() const
{
	return pnew pgsNot(*this);
}

pgsNot::pgsNot(const pgsNot & that) :
	pgsOperation(that)
{

}

pgsNot & pgsNot::operator =(const pgsNot & that)
{
	if (this != &that)
	{
		pgsOperation::operator=(that);
	}
	return (*this);
}

wxString pgsNot::value() const
{
	return wxString() << wxT("!") << m_left->value();
}

pgsOperand pgsNot::eval(pgsVarMap & vars) const
{
	// Evaluate operands
	pgsOperand left(m_left->eval(vars));
	
	// Return the result
	return (!(*left));
}
