/*--------------------------------------------------------------------
 * FILE:
 *     probe_get_pglb_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Get_Pglb_Status(void);
ClusterTbl * PGC_Get_Pglb_Shm(char * path);
int PGC_Send_Pglb_Status(Pglb_Info * pglb, ClusterTbl * cluster );
int PGC_Get_ClusterTbl_Rec_Num(ClusterTbl * cluster);

int
PGC_Get_Pglb_Status(void)
{
	char * func = "PGC_Get_Pglb_Status()";
	Pglb_Info * pglb = NULL;
	int count = 0;
	ClusterTbl * cluster = NULL;

	if (PglbTbl == NULL)
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	pglb = PglbTbl;

	count = 0;
	while (pglb->receivePortNumber != 0)
	{
		cluster = PGC_Get_Pglb_Shm(pglb->workPath);
		if (cluster != NULL)
		{
			PGC_Send_Pglb_Status(pglb, cluster );	
			shmdt((char *)cluster);
			cluster = NULL;
		}
		else
		{
			pglb->status = DATA_ERR;
			PGC_Send_Pglb_Status(pglb, NULL );	
		}
		count ++;
		pglb ++;
	}
	return STATUS_OK;
}

ClusterTbl *
PGC_Get_Pglb_Shm(char * path)
{
	char * func = "PGC_Get_Pglb_Shm()";
	ClusterTbl * cluster = NULL;
	IPCInfo ipc_list[4];
	int rtn = 0;

	memset(ipc_list, 0, sizeof(ipc_list));
	rtn = PGR_Get_IPC_File(path, PGLB_IPC_FILE, ipc_list);
	if (rtn < 0)
	{
		show_error("%s:PGR_Get_IPC_File failed",func);
		return NULL;
	}
	cluster = (ClusterTbl *)shmat(ipc_list[0].shmid,0,0);
	if (cluster == (ClusterTbl *)-1)
	{
		show_error("%s:shmat failed (%s)",func,strerror(errno));
		return NULL;
	}
	return cluster;
}

int
PGC_Send_Pglb_Status(Pglb_Info * pglb, ClusterTbl * cluster )
{
	char * func ="PGC_Send_Pglb_Status()";
	Probe_Header r_header;
	Probe_Header h_data;
	int cluster_num = 0;
	char * body = NULL;
	int size = 0;
	ClusterTbl * cp = NULL;
	char * p = NULL;
	int status = STATUS_OK;

	if (pglb == NULL)
	{
		show_error("%s:table is null",func);
		return STATUS_ERROR;
	}
	cluster_num = PGC_Get_ClusterTbl_Rec_Num(cluster);
	size = sizeof(Pglb_Info) + ( sizeof(ClusterTbl) * (cluster_num));
	body = (char *)malloc(size);
	if (body == NULL)
	{
		show_error("%s: malloc failed (%s)",func, strerror(errno));
		return STATUS_ERROR;
	}
	memset(body, 0, size);
	p = body;
	PGC_Set_Pglb_Info_2_packet((Pglb_Info *)p, pglb);
	if (cluster_num > 0)
	{
		p = body + sizeof(Pglb_Info);
		cp = cluster;
		while(cp->port != 0)
		{
			PGC_Set_ClusterTbl_2_packet((ClusterTbl *)p,cp);
			p += sizeof(ClusterTbl);
			cp ++;
		}
	}
	h_data.packet_no = GET_STS_ANS_PKT;
	h_data.serverType = SERVER_TYPE_PGLB;
	h_data.body_length = size;
	h_data.rec_num = cluster_num;
	PGC_Set_Packet_Header(&r_header, &h_data);
	status = PGC_Probe_Send_Packet(&r_header,(char*)body);
	if (body != NULL)
	{
		free(body);
		body = NULL;
	}
	return status;
}

int
PGC_Get_ClusterTbl_Rec_Num(ClusterTbl * cluster)
{
	char * func="PGC_Get_ClusterTbl_Rec_Num()";
	int cluster_num = 0;
	ClusterTbl * cp = NULL;

	if (cluster == NULL)
	{
		show_error("%s: cluster tbl is null",func);
		return 0;
	}
	cp = cluster;
	while(cp->port != 0)
	{
		cluster_num ++;
		cp ++;
	}
	return cluster_num;
}
