/*--------------------------------------------------------------------
 * FILE:
 *     probe_get_cluster_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <errno.h>
#include <fcntl.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Get_Cluster_Status(void);
ReplicateServerInfo * PGC_Get_Cluster_Shm(char * path);
int PGC_Send_Cluster_Status(Cluster_Info * cluster, ReplicateServerInfo * replicate );
int PGC_Get_ReplicateServerInfo_Rec_Num(ReplicateServerInfo * replicate);

int
PGC_Get_Cluster_Status(void)
{
	char * func = "PGC_Get_Cluster_Status()";
	Cluster_Info * cluster = NULL;
	int count = 0;
	ReplicateServerInfo * replicate = NULL;

	if (ClusterDbTbl == NULL)
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	cluster = ClusterDbTbl;
	count = 0;
	while ((cluster->status != 0) && (count < MAX_DB_SERVER))
	{
		replicate = PGC_Get_Cluster_Shm(cluster->workPath);
		if (replicate != NULL)
		{
			PGC_Send_Cluster_Status(cluster, replicate );	
			shmdt((char *)replicate);
			replicate = NULL;
		}
		else
		{
			cluster->status = DATA_ERR;
			PGC_Send_Cluster_Status(cluster, NULL );	
		}
		count ++;
	}
	return STATUS_OK;
}

ReplicateServerInfo *
PGC_Get_Cluster_Shm(char * path)
{
	char * func = "PGC_Get_Cluster_Shm()";
	IPCInfo ipc_list[4];
	int rtn = 0;
	ReplicateServerInfo * replicate = NULL;

	memset(ipc_list, 0, sizeof(ipc_list));
	rtn = PGR_Get_IPC_File(path, CLUSTER_IPC_FILE, ipc_list);
	if (rtn <= 0)
	{
		show_error("%s:PGR_Get_IPC_File failed",func);
		return NULL;
	}
	replicate = (ReplicateServerInfo *)shmat(ipc_list[0].shmid,0,0);
	if (replicate == (ReplicateServerInfo *)-1)
	{
		show_error("%s:shmat failed (%s)",func,strerror(errno));
		return NULL;
	}
	return replicate;
}

int
PGC_Send_Cluster_Status(Cluster_Info * cluster, ReplicateServerInfo * replicate )
{
	char * func ="PGC_Send_Cluster_Status()";
	Probe_Header r_header;
	Probe_Header h_data;
	int replicate_num = 0;
	char * body = NULL;
	int size = 0;
	ReplicateServerInfo * cp = NULL;
	char * p = NULL;
	int status = STATUS_OK;

	replicate_num = PGC_Get_ReplicateServerInfo_Rec_Num(replicate);
	size = sizeof(Cluster_Info) + ( sizeof(ReplicateServerInfo) * (replicate_num ));
	body = (char *)malloc(size);
	if (body == NULL)
	{
		show_error("%s: malloc failed (%s)",func, strerror(errno));
		return STATUS_ERROR;
	}
	memset(body, 0, size);
	p = (char *)body;
	PGC_Set_Cluster_Info_2_packet((Cluster_Info *)p, cluster);
	if (replicate_num > 0)
	{
		p = body + sizeof(ReplicateServerInfo);
		cp = replicate;
		while(cp->portNumber != 0)
		{
			PGC_Set_ReplicateServerInfo_2_packet((ReplicateServerInfo *)p,cp);
			p += sizeof(ReplicateServerInfo);
			cp ++;
		}
	}
	h_data.packet_no = GET_STS_ANS_PKT;
	h_data.serverType = SERVER_TYPE_CLUSTER;
	h_data.body_length = size;
	h_data.rec_num = replicate_num;
	PGC_Set_Packet_Header(&r_header, &h_data);
	status = PGC_Probe_Send_Packet(&r_header,body);
	if (body != NULL)
	{
		free(body);
		body = NULL;
	}
	return status;
}

int
PGC_Get_ReplicateServerInfo_Rec_Num(ReplicateServerInfo * replicate)
{
	int replicate_num = 0;
	ReplicateServerInfo * cp = NULL;
	if (replicate == NULL)
	{
		return 0;
	}
	cp = replicate;
	while(cp->portNumber != 0)
	{
		replicate_num ++;
		cp ++;
	}
	return replicate_num;
}
