/*--------------------------------------------------------------------
 * FILE:
 *     admin_user_req.c
 *
 * NOTE:
 *     This file is composed of the admin process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

uint16_t PGC_Admin_User_Exec_Req(uint16_t packet_no, uint16_t serverType, uint16_t serverNo);
int PGC_Admin_User_Status_Req(SSL_Info * ssl_tbl, uint16_t serverType, uint16_t serverNo);

static Pglb_Info * get_pglb_tbl(uint16_t serverNo);
static Cluster_Info * get_cluster_db_tbl(uint16_t serverNo);
static Pgrp_Info * get_pgrp_tbl(uint16_t serverNo);

uint16_t 
PGC_Admin_User_Exec_Req(uint16_t packet_no, uint16_t serverType, uint16_t serverNo)
{
	char * tbl= NULL;
	uint16_t status = 0;
	
	switch (serverType)
	{
		case SERVER_TYPE_PGLB:
			tbl = (char *)get_pglb_tbl(serverNo);
			status = PGC_Admin_Exec_Pglb(packet_no, (Pglb_Info *)tbl);
			break;
		case SERVER_TYPE_CLUSTER:
			tbl = (char *)get_cluster_db_tbl(serverNo);
			status = PGC_Admin_Exec_Cluster(packet_no, (Cluster_Info *)tbl);
			break;
		case SERVER_TYPE_PGRP:
			tbl = (char *)get_pgrp_tbl(serverNo);
			status = PGC_Admin_Exec_Pgrp(packet_no, (Pgrp_Info *)tbl);
			break;
		default:
			break;
	}
	return status;
}

int
PGC_Admin_User_Status_Req(SSL_Info * ssl_tbl, uint16_t serverType, uint16_t serverNo)
{
	char * tbl= NULL;
	int status = 0;
	Probe_Header header;
	
	switch (serverType)
	{
		case SERVER_TYPE_PGLB:
			tbl = (char *)get_pglb_tbl(serverNo);
			header.body_length = htonl(sizeof(Pglb_Info));
			break;
		case SERVER_TYPE_CLUSTER:
			tbl = (char *)get_cluster_db_tbl(serverNo);
			header.body_length = htonl(sizeof(Cluster_Info));
			break;
		case SERVER_TYPE_PGRP:
			tbl = (char *)get_pgrp_tbl(serverNo);
			header.body_length = htonl(sizeof(Pgrp_Info));
			break;
		default:
			break;
	}

	if (tbl != NULL)
	{
		header.rec_num = htonl(1);
	}
	memset(&header, 0, sizeof(Probe_Header));
	header.packet_no = htons(USER_STATUS_ANS_PKT);
	header.serverType = htons(serverType);
	header.serverNo = htons(serverNo);

	status = PGC_Send_Status_Packet(ssl_tbl, &header, tbl);
	
	return status;
}

static Pglb_Info *
get_pglb_tbl(uint16_t serverNo)
{
	Pglb_Info * pglb = NULL;
	
	if (PglbTbl == NULL)
		return NULL;
	pglb = PglbTbl;
	while (pglb->receivePortNumber != 0)
	{
		if (pglb->serverNo == serverNo)
		{
			return pglb;
		}
		pglb ++;
	}
	return NULL;
}

static Cluster_Info *
get_cluster_db_tbl(uint16_t serverNo)
{
	Cluster_Info * cluster = NULL;
	
	if (ClusterDbTbl == NULL)
		return NULL;
	cluster = ClusterDbTbl;
	while (cluster->portNumber != 0)
	{
		if (cluster->serverNo == serverNo)
		{
			return cluster;
		}
		cluster ++;
	}
	return NULL;
}

static Pgrp_Info *
get_pgrp_tbl(uint16_t serverNo)
{
	Pgrp_Info * pgrp = NULL;
	
	if (PgrpTbl == NULL)
		return NULL;
	pgrp = PgrpTbl;
	while (pgrp->replicationPortNumber != 0)
	{
		if (pgrp->serverNo == serverNo)
		{
			return pgrp;
		}
		pgrp ++;
	}
	return NULL;
}
