/*--------------------------------------------------------------------
 * FILE:
 *     probe_init.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Probe_Init(SSL_Info * ssl_tbl, Probe_Header * header, SSL_Server_Info * packet);

int
PGC_Probe_Init(SSL_Info * ssl_tbl, Probe_Header * header, SSL_Server_Info * packet)
{
	char * func = "PGC_Probe_Init()";
	int status = STATUS_OK;
	Probe_Header h_data;
	Probe_Header r_header;
	SSL_Server_Info * admin = NULL;

	if (AdminTbl == NULL)
	{
		show_error("%s:AdminTbl is NULL",func);
		return STATUS_ERROR;
	}

	admin = PGC_Get_SSL_Server_Rec(AdminTbl, ntohs(packet->serverNo));
	if (admin->status != DATA_USE)
	{
		h_data.packet_no = INIT_INFO_REQ_PKT;
		admin->status = DATA_USE;
	}
	else
	{
		/*
		h_data.packet_no = INIT_OK_PKT;
		*/
		h_data.packet_no = INIT_INFO_REQ_PKT;
	}
	h_data.serverType = SERVER_TYPE_PROBE;
	h_data.body_length = 0;
	h_data.rec_num = 0;
	PGC_Set_SSL_Admin(&h_data, packet);
	memset(&r_header, 0, sizeof(Probe_Header));
	PGC_Set_Packet_Header(&r_header, &h_data);
	status = PGC_Send_Status_Packet(ssl_tbl, &r_header,(char *)NULL);

	return status;
}
