/*--------------------------------------------------------------------
 * FILE:
 *     probe_get_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Probe_Get_Status(Probe_Header * header, char * packet);

int
PGC_Probe_Get_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Probe_Get_Status()";
	int status = STATUS_ERROR;

	switch (ntohs(header->serverType))
	{
		case SERVER_TYPE_PGLB:
			status = PGC_Get_Pglb_Status();
			show_debug("%s:PGC_Get_Pglb_Status [%d]\n",func,status);
			break;
		case SERVER_TYPE_CLUSTER:
			status = PGC_Get_Cluster_Status();
			show_debug("%s:PGC_Get_Cluster_Status [%d]\n",func,status);
			break;
		case SERVER_TYPE_PGRP:
			status = PGC_Get_Pgrp_Status();
			show_debug("%s:PGC_Get_Pgrp_Status [%d]\n",func,status);
			break;
		default :
			break;
	}

	return status;
}
