.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "LOCK" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
LOCK \- explicitly lock a table
.SH SYNOPSIS
.sp
.nf
LOCK [ TABLE ] \fIname\fR [, ...]
LOCK [ TABLE ] \fIname\fR [, ...] IN \fIlockmode\fR MODE

where \fIlockmode\fR is one of:

	ACCESS SHARE | ROW SHARE | ROW EXCLUSIVE | SHARE UPDATE EXCLUSIVE |
	SHARE | SHARE ROW EXCLUSIVE | EXCLUSIVE | ACCESS EXCLUSIVE
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing table to lock.
.TP
\fBACCESS SHARE MODE\fR
This is the least restrictive lock mode. It conflicts only with
ACCESS EXCLUSIVE mode. It is used to protect a table from being
modified by concurrent \fBALTER TABLE\fR, 
\fBDROP TABLE\fR and \fBVACUUM FULL\fR
commands.
.sp
.RS
.B "Note:"
The \fBSELECT\fR command acquires a
lock of this mode on referenced tables. In general, any query
that only reads a table and does not modify it will acquire
this lock mode.
.RE
.sp
.TP
\fBROW SHARE MODE\fR
Conflicts with EXCLUSIVE and ACCESS EXCLUSIVE lock modes.
.sp
.RS
.B "Note:"
The \fBSELECT FOR UPDATE\fR command acquires a
lock of this mode on the target table(s) (in addition to
ACCESS SHARE locks on any other tables
that are referenced but not selected \fBFOR UPDATE\fR).
.RE
.sp
.TP
\fBROW EXCLUSIVE MODE\fR
Conflicts with SHARE, SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes.
.sp
.RS
.B "Note:"
The commands \fBUPDATE\fR,
\fBDELETE\fR, and \fBINSERT\fR
acquire this lock mode on the target table (in addition to
ACCESS SHARE locks on any other referenced
tables). In general, this lock mode will be acquired by any
query that modifies the data in a table.
.RE
.sp
.TP
\fBSHARE UPDATE EXCLUSIVE MODE\fR
Conflicts with SHARE UPDATE EXCLUSIVE, SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and
ACCESS EXCLUSIVE modes. This mode protects a table against
concurrent schema changes and \fBVACUUM\fR runs.
.sp
.RS
.B "Note:"
Acquired by \fBVACUUM\fR (without
\fBFULL\fR).
.RE
.sp
.TP
\fBSHARE MODE\fR
Conflicts with ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE,
SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes. This mode protects a table against
concurrent data changes.
.sp
.RS
.B "Note:"
Acquired by \fBCREATE INDEX\fR.
.RE
.sp
.TP
\fBSHARE ROW EXCLUSIVE MODE\fR
Conflicts with ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE, SHARE,
SHARE ROW EXCLUSIVE, EXCLUSIVE and ACCESS EXCLUSIVE modes.
.sp
.RS
.B "Note:"
This lock mode is not automatically acquired by any
PostgreSQL command.
.RE
.sp
.TP
\fBEXCLUSIVE MODE\fR
Conflicts with ROW SHARE, ROW EXCLUSIVE, SHARE UPDATE EXCLUSIVE,
SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and ACCESS EXCLUSIVE modes.
This mode allows only concurrent ACCESS SHARE, i.e., only reads
from the table can proceed in parallel with a transaction holding
this lock mode.
.sp
.RS
.B "Note:"
This lock mode is not automatically acquired by any
PostgreSQL command.
.RE
.sp
.TP
\fBACCESS EXCLUSIVE MODE\fR
Conflicts with all lock modes. This mode guarantees that the
holder is the only transaction accessing the table in any way.
.sp
.RS
.B "Note:"
Acquired by \fBALTER TABLE\fR,
\fBDROP TABLE\fR, and \fBVACUUM FULL\fR
statements.
This is also the default lock mode for \fBLOCK TABLE\fR
statements that do not specify a mode explicitly.
.RE
.sp
.PP
.SS "OUTPUTS"
.PP
.TP
\fBLOCK TABLE\fR
The lock was successfully acquired.
.TP
\fBERROR \fIname\fB: Table does not exist.\fR
Message returned if \fIname\fR
does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBLOCK TABLE\fR obtains a table-level lock, waiting if
necessary for any conflicting locks to be released. Once obtained,
the lock is held for the remainder of the current transaction.
(There is no \fBUNLOCK TABLE\fR command; locks are always
released at transaction end.)
.PP
When acquiring locks automatically for commands that reference tables,
PostgreSQL always uses the least restrictive
lock mode possible. \fBLOCK TABLE\fR 
provides for cases when you might need more restrictive locking.
.PP
For example, suppose an application runs a transaction at READ COMMITTED
isolation level and needs to ensure that data in a table remains stable
for the duration of the
transaction. To achieve this you could obtain SHARE lock mode over the
table before querying. This will prevent concurrent data changes
and ensure subsequent reads of the table see a stable
view of committed data, because SHARE lock mode conflicts with the ROW
EXCLUSIVE lock acquired by writers, and your
\fBLOCK TABLE \fIname\fB IN SHARE MODE\fR
statement will wait until any concurrent holders of ROW EXCLUSIVE mode
commit or roll back. Thus, once you obtain the lock, there are no
uncommitted writes outstanding; furthermore none can begin until you
release the lock.
.sp
.RS
.B "Note:"
To achieve a similar effect when running a transaction
at the SERIALIZABLE isolation level, you have to execute the
\fBLOCK TABLE\fR
statement before executing any DML statement. A serializable
transaction's view of data will be frozen when its first DML statement
begins. A later \fBLOCK\fR will still prevent concurrent writes
--- but it
won't ensure that what the transaction reads corresponds to the latest
committed values.
.RE
.sp
.PP
If a transaction of this sort is going to
change the data in the table, then it should use SHARE ROW EXCLUSIVE lock
mode instead of SHARE mode. This ensures that only one transaction of
this type runs at a time. Without this, a deadlock is possible: two
transactions might both acquire SHARE mode, and then be unable to also
acquire ROW EXCLUSIVE mode to actually perform their updates. (Note that
a transaction's own locks never conflict, so a transaction can acquire
ROW EXCLUSIVE mode when it holds SHARE mode --- but not if anyone else
holds SHARE mode.)
.PP
Two general rules may be followed to prevent deadlock conditions:
.TP 0.2i
\(bu
Transactions have to acquire locks on the same objects in the same order.

For example, if one application updates row R1 and than updates 
row R2 (in the same transaction) then the second application shouldn't 
update row R2 if it's going to update row R1 later (in a single transaction). 
Instead, it should update rows R1 and R2 in the same order as the first 
application.
.TP 0.2i
\(bu
If multiple lock modes are involved for a single object,
then transactions should always acquire the most restrictive mode first.

An example for this rule was given previously when discussing the 
use of SHARE ROW EXCLUSIVE mode rather than SHARE mode.
.PP
PostgreSQL does detect deadlocks and will
rollback at least one waiting transaction to resolve the deadlock.
If it is not practical to code an application to follow the above rules
strictly, an alternative solution is to be prepared to retry transactions
when they are aborted by deadlocks.
.PP
.PP
When locking multiple tables, the command LOCK a, b; is
equivalent to LOCK a; LOCK b;. The tables are locked one-by-one
in the order specified in the
\fBLOCK\fR command.
.PP
.SS "NOTES"
.PP
LOCK ... IN ACCESS SHARE MODE requires SELECT
privileges on the target table. All other forms of \fBLOCK\fR
require UPDATE and/or DELETE privileges.
.PP
\fBLOCK\fR is useful only inside a transaction block
(\fBBEGIN\fR...\fBCOMMIT\fR), since the lock is dropped
as soon as the transaction ends. A \fBLOCK\fR command appearing
outside any transaction block forms a self-contained transaction, so the
lock will be dropped as soon as it is obtained.
.PP
RDBMS locking uses the following standard terminology:
.TP
\fBEXCLUSIVE\fR
An exclusive lock prevents other locks of the same type from being
granted.
.TP
\fBSHARE\fR
A shared lock allows others to also hold the same type of lock,
but prevents the corresponding EXCLUSIVE lock from being granted.
.TP
\fBACCESS\fR
Locks table schema.
.TP
\fBROW\fR
Locks individual rows.
.PP
.PP
PostgreSQL does not follow this terminology
exactly. \fBLOCK TABLE\fR only deals with table-level locks, and
so the mode names involving ROW are all misnomers. These mode names
should generally be read as indicating the intention of the user to
acquire row-level locks within the locked table. Also,
ROW EXCLUSIVE mode does not follow this naming convention accurately,
since it is a sharable table lock. Keep in mind that all the lock modes
have identical semantics so far as \fBLOCK TABLE\fR is concerned,
differing only in the rules about which modes conflict with which.
.SH "USAGE"
.PP
Obtain a SHARE lock on a primary key table when going to perform
inserts into a foreign key table:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE MODE;
SELECT id FROM films 
    WHERE name = 'Star Wars: Episode I - The Phantom Menace';
-- Do ROLLBACK if record was not returned
INSERT INTO films_user_comments VALUES 
    (_id_, 'GREAT! I was waiting for it for so long!');
COMMIT WORK;
   
.sp
.fi
.PP
Take a SHARE ROW EXCLUSIVE lock on a primary key table when going to perform
a delete operation:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE ROW EXCLUSIVE MODE;
DELETE FROM films_user_comments WHERE id IN
    (SELECT id FROM films WHERE rating < 5);
DELETE FROM films WHERE rating < 5;
COMMIT WORK;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBLOCK TABLE\fR in SQL92,
which instead uses \fBSET TRANSACTION\fR to specify
concurrency levels on transactions. We support that too; see
SET TRANSACTION [\fBset_transaction\fR(l)] for details.
.PP
Except for ACCESS SHARE, ACCESS EXCLUSIVE, and SHARE UPDATE EXCLUSIVE lock
modes, the PostgreSQL lock modes and the
\fBLOCK TABLE\fR syntax are compatible with those
present in Oracle(TM).
