.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP RULE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP RULE \- remove a rewrite rule
.SH SYNOPSIS
.sp
.nf
DROP RULE \fIname\fR ON \fIrelation\fR [ CASCADE | RESTRICT ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing rule to drop.
.TP
\fB\fIrelation\fB\fR
The name (optionally schema-qualified) of the relation the rule
applies to.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the rule.
.TP
\fBRESTRICT\fR
Refuse to drop the rule if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP RULE\fR
Message returned if successful.
.TP
\fBERROR: Rule "\fIname\fB" not found\fR
This message occurs if the specified rule does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP RULE\fR drops a rule from the specified
PostgreSQL rule
system. PostgreSQL
will immediately cease enforcing it and
will purge its definition from the system catalogs.
.SS "NOTES"
.PP
The \fBDROP RULE\fR statement is a
PostgreSQL
language extension.
.PP
Refer to \fBCREATE RULE\fR for
information on how to create rules.
.SH "USAGE"
.PP
To drop the rewrite rule newrule:
.sp
.nf
DROP RULE newrule ON mytable;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP RULE\fR in SQL92.
