/*
 * Written by Tomas Dosoudil <tomas.dosoudil@gmail.com>
 * This file is distributed under BSD-style license.
 *
 */

#ifndef _INPUT_PARSER_H_
#define _INPUT_PARSER_H_

/* structure for linked list, where range is save */
typedef struct LinkedList {
		int from;
		int to;
		struct LinkedList *next;
} LinkedList;

/* function that returns pointer to list of range */
extern LinkedList* GetLinkedList(char*, int);

/* functions returns allocated structure */
extern LinkedList* AllocateNewNode(void);

/* deallocated linked list */
extern void FreeLinkedList(LinkedList**);

#endif /* _INPUT_PARSER_H_ */
