#include "postgres.h"

#include "fmgr.h"
#include "catalog/dependency.h"
#include "catalog/pg_class.h"
#include "catalog/toasting.h"

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

Datum		pg_toasttbl_recreate(PG_FUNCTION_ARGS);
Datum		pg_toasttbl_drop(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(pg_toasttbl_recreate);
PG_FUNCTION_INFO_V1(pg_toasttbl_drop);

/*
 * recreates a toast table with the specified oid of the given parent
 * table oid. Strictly written for pg_migrator. Assumes that the called
 * has already removed the old pg_toast and pg_toast_index relations
 * and also the pg_type entry for parent table.
 */
Datum
pg_toasttbl_recreate(PG_FUNCTION_ARGS)
{
	Oid			parent_relid = PG_GETARG_OID(0);
	Oid			toast_relid = PG_GETARG_OID(1);

	/* preserve TOAST options? */
	AlterTableCreateToastTable(parent_relid, toast_relid, (Datum) 0, true);

	PG_RETURN_VOID();
}


/*
 * drop toast table
 */
Datum
pg_toasttbl_drop(PG_FUNCTION_ARGS)
{
	Oid			toast_relid = PG_GETARG_OID(0);
	ObjectAddresses *objects;
    ObjectAddress obj;

	obj.classId = RelationRelationId;
	obj.objectId = toast_relid;
	obj.objectSubId = 0;

    objects = new_object_addresses();
	add_exact_object_address(&obj, objects);
    
    performMultipleDeletions(objects, DROP_RESTRICT);

    free_object_addresses(objects);

	PG_RETURN_VOID();
}
