#ifndef __COMMON__
#define __COMMON__

#include "odbc.h"
#include <stdarg.h>

#define LIST_ITEMS_NUMBER          10

typedef struct _list
{
	SQLHANDLE* handles;
	int        allocated;
	int        used;
} List;

SQLRETURN AddItem(List* pList, SQLHANDLE Handle); 
SQLRETURN RemoveItem(List* pList, SQLHANDLE Handle); 
SQLRETURN FreeList(List* pList, SQLSMALLINT HandleType);
SQLRETURN ReturnString(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, const TCHAR* SourceValue, SQLSMALLINT nSourceLength, BOOL in_bytes);
SQLRETURN EncryptPasswordMD5(const BYTE* pwd, const BYTE* uid, const BYTE* code, BYTE* password);
SQLRETURN PrepareConnectionString(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, TCHAR** parameters, TCHAR* dsn);
SQLRETURN PrepareConnectionStringRequest(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, TCHAR** parameters);

SQLLEN FillBufferWithValue(SQLPOINTER TargetValue, SQLLEN TargetLength, SQLSMALLINT TargetType, TCHAR* SourceValue, SQLINTEGER SourceLength, SQLSMALLINT SourceType);

TCHAR* GetTextFromArray(const TCHAR* szBaseText, int array_size, const TCHAR** szParameters);
TCHAR* PrepareText(const TCHAR* szBaseText, const TCHAR* szParameters, va_list vaList);
TCHAR* GetText(const TCHAR* szBaseText, const TCHAR* szParameters, ...);

/* type information functions */
SQLSMALLINT GetDefaultType(SQLSMALLINT c_type);
SQLSMALLINT GetCDefaultType(SQLSMALLINT sql_type);
SQLSMALLINT GetIntervalSubType(SQLSMALLINT sql_type);
SQLLEN      GetCTypeLength(SQLSMALLINT c_type, SQLLEN char_length);

int GetInt(TCHAR** pPtr, TCHAR terminator, SQLINTEGER* pLength, int radix);
void EmptyConnectionParameters(TCHAR** parameters);

SQLRETURN SQLTypeDescriptor(SQLSMALLINT  concise_type,
									SQLSMALLINT  is_unsigned,
									SQLLEN*      pLength,
									SQLSMALLINT* pPrecision,
									SQLSMALLINT* pScale,
									SQLSMALLINT* pSQLType, 
									SQLULEN*     pDisplaySize,
									SQLINTEGER*  pIntervalPrecision,
									SQLINTEGER*  pNumPrecRadix);

SQLRETURN PostgreTypeToSQLType(SQLINTEGER oid, SQLINTEGER modifier, SQLUINTEGER odbc_version, TCHAR** type_name, SQLSMALLINT* concise_sql_type, SQLINTEGER* length, SQLSMALLINT* precision, BOOL mjet);
SQLRETURN DescribeSQLType(SQLSMALLINT concise_sql_type, SQLINTEGER length, SQLSMALLINT precision, SQLSMALLINT* sql_type, SQLINTEGER* data_size, SQLINTEGER* num_prec_radix, SQLULEN* display_size);
/*---------------------------------------------------------
 *---------------------------------------------------------
 */

typedef enum {
	ET_NO_ESCAPES = 0x00,
	ET_TIME       = 0x01,
	ET_DATE       = 0x02,
	ET_TIMESTAMP  = 0x04,
	ET_ESCAPE     = 0x08,
	ET_OUTER_JOIN = 0x10,
	ET_PROCEDURE  = 0x20,
	ET_FUNCTION   = 0x40
} ESCAPE_TYPE;


typedef struct _sf
{
	TCHAR* odbc_function;
	TCHAR* postgresql_function;
	VOID*  function;
} ScalarFunction;

const ScalarFunction c_ScalarFunctions[22];

#ifndef WIN32
	char* itoa (int value, char* string, int radix);
#endif /* WIN32 */

#ifdef UNICODE
	int utf8len(WCHAR* String, int Length);
#endif /* UNICODE */
#endif /* __COMMON__ */
