#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Accounts Receivable module backend routines
#
#======================================================================

package debitnote2;


sub post_transaction {
  my ($self, $myconfig, $form) = @_;

  my ($null, $taxrate, $amount);
  my $exchangerate = 0;

  $form->{callback} .= "&transdate=$form->{transdate}";

  # split and store id numbers in link accounts
  ($null,$form->{customer_id}) = split(/--/, $form->{customer});
  ($form->{AR}{amount}) = split(/--/, $form->{AR_amount});
  ($form->{AR}{receivables}) = split(/--/, $form->{AR});

  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, 'buy');
  }
  
  $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});

  $amount = $form->round_amount($form->parse_amount($myconfig, $form->{amount}), 2);
  
  $form->{amount} = $form->round_amount($amount * $form->{exchangerate}, 2);

  # taxincluded doesn't make sense if there is no amount
  $form->{taxincluded} = 0 if ($form->{amount} == 0);

  foreach my $item (split / /, $form->{taxaccounts}) {
    $form->{AR}{"tax_$item"} = $item;

    $amount = $form->round_amount($form->parse_amount($myconfig, $form->{"tax_$item"}), 2);
    
    $form->{"tax_$item"} = $form->round_amount($amount * $form->{exchangerate}, 2);
    $form->{total_tax} += $form->{"tax_$item"};

  }


  # adjust paidaccounts if there is no date in the last row
  $form->{paidaccounts}-- unless ($form->{"datepaid_$form->{paidaccounts}"});

  $form->{invpaid} = 0;
  # add payments
  for my $i (1 .. $form->{paidaccounts}) {
    $form->{"paid_$i"} = $form->round_amount($form->parse_amount($myconfig, $form->{"paid_$i"}), 2);
    
    $form->{invpaid} += $form->{"paid_$i"};
    $form->{datepaid} = $form->{"datepaid_$i"};

    # reverse payment
    $form->{"paid_$i"} *= -1;

  }

  
  if ($form->{taxincluded} *= 1) {
    $form->{amount} -= $form->{total_tax};
  }


  $form->{invpaid} = $form->round_amount($form->{invpaid} * $form->{exchangerate}, 2);

  # store invoice total, this goes into ar table
  $form->{invtotal} = $form->{amount} + $form->{total_tax};

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $uid, $sth);

  # if we have an id delete old records
  if ($form->{id}) {

    # delete detail records
    $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);

  } else {
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO debitnote (ordnumber,invoice, employee_id)
                VALUES ('$uid','false', (SELECT id FROM employee
		                 WHERE login = '$form->{login}') )|;
    $dbh->do($query) || $form->dberror($query);

    # retrieve id
    $query = qq|SELECT id
                FROM debitnote
		WHERE ordnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;

  }

  # escape '
  $form->{notes} =~ s/'/\\'/g;

  # record last payment date in ar table
  $form->{datepaid} = $form->{transdate} unless $form->{datepaid};
  my $datepaid = ($form->{invpaid} != 0) ? qq|'$form->{datepaid}'| : 'NULL';

  if($form->{vc} eq "customer"){
	$form->{vendor_id} =0;
	$form->{customer_id}=$form->{customer_id};
  }else{
	$form->{vendor_id} =$form->{customer_id};
	$form->{customer_id}=0;
  }

  $query = qq|UPDATE debitnote set
	      ordnumber = '$form->{ordnumber}',
	      transdate = '$form->{transdate}',
	      customer_id = $form->{customer_id},
	      vendor_id = $form->{vendor_id},
	      taxincluded = '$form->{taxincluded}',
	      amount = $form->{invtotal},
	      netamount = $form->{amount},
	      curr = '$form->{currency}',
	      transno = '$form->{transno}',
	      batch = '$form->{batch}',
	      transtype = '$form->{transtype}',
	      subtransno = '$form->{subtransno}',
	      notes = '$form->{notes}'
	      WHERE id = $form->{id}|;
	       
	#       $form->dberror($query);

  $dbh->do($query) || $form->dberror($query);


  # amount for AR account
  $form->{receivables} = $form->round_amount($form->{invtotal} * -1, 2);


  # update exchangerate
  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    $form->update_exchangerate($dbh, $form->{currency}, $form->{transdate}, $form->{exchangerate}, 0);
  }

  ################################## adjust here insert acc_trans transactions
    # extract accno
    ($accno) = split(/--/, $form->{"accno_1"});
    my $amount1 = $amount*-1;

    # if there is an amount, add the record
    if ($amount1 != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount1, '$form->{transdate}', '$form->{ordnumber}' )|;

      $dbh->do($query) || $form->dberror($query);


   }
 # }

     ###add credit
   ($accno) = split(/--/, $form->{"accno_2"});
    my $amount2 = $amount;

   # if there is an amount, add the record
   if ($amount2 != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount2, '$form->{transdate}', '$form->{ordnumber}' )|;

      $dbh->do($query) || $form->dberror($query);
  }
  ######################################################

  # add individual transactions for AR, amount and taxes
  #foreach my $item (keys %{ $form->{AR} }) {
 #   if ($form->{$item} != 0) {
      # insert detail records in acc_trans
 #     $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate)
#		  VALUES ($form->{id}, (SELECT id FROM chart
#		                        WHERE accno = '$form->{AR}{$item}'),
#		  $form->{$item}, '$form->{transdate}')|;
 #     $dbh->do($query) || $form->dberror($query);
 #   }
 # }

  # if there is no amount but a payment record a receivables
  if ($form->{amount} == 0 && $form->{invtotal} == 0) {
    $form->{receivables} = $form->{invpaid} * -1;
  }

  # add paid transactions
  for my $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"} != 0) {

       ($form->{AR}{"paid_$i"}) = split(/--/, $form->{"AR_paid_$i"});
      $form->{"datepaid_$i"} = $form->{transdate} unless ($form->{"datepaid_$i"});

      $exchangerate = 0;
      if ($form->{currency} eq $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = 1;
      } else {
	$exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'buy');

	$form->{"exchangerate_$i"} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{"exchangerate_$i"});
      }


      # if there is no amount and invtotal is zero there is no exchangerate
      if ($form->{amount} == 0 && $form->{invtotal} == 0) {
	$form->{exchangerate} = $form->{"exchangerate_$i"};
      }

      # receivables amount
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{exchangerate} * -1, 2);

      if ($form->{receivables}) {
	# add receivable
#	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
#		    transdate,source)
#		    VALUES ($form->{id},
#		           (SELECT id FROM chart
#			    WHERE accno = '$form->{AR}{receivables}'),
#		    $amount, '$form->{"datepaid_$i"}','$form->{"source_$i"}')|;
#	$dbh->do($query) || $form->dberror($query);
      }
      $form->{receivables} = $amount;

      # add payment
#      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
#		  transdate, source)
#		  VALUES ($form->{id},
#		         (SELECT id FROM chart
##			  WHERE accno = '$form->{AR}{"paid_$i"}'),
#		  $form->{"paid_$i"}, '$form->{"datepaid_$i"}',
##		  '$form->{"source_$i"}')|;
 #     $dbh->do($query) || $form->dberror($query);


      # exchangerate difference for payment
      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{"exchangerate_$i"} - 1), 2);

      if ($amount != 0) {
#	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
##		    transdate, fx_transaction, cleared)
#		    VALUES ($form->{id},
#		           (SELECT id FROM chart
#			    WHERE accno = '$form->{AR}{"paid_$i"}'),
#		    $amount, '$form->{"datepaid_$i"}', '1', '1')|;
#	$dbh->do($query) || $form->dberror($query);
      }

      # exchangerate gain/loss
      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{exchangerate} - $form->{"exchangerate_$i"}), 2);

      if ($amount != 0) {
	$accno = ($amount > 0) ? $form->{fxgain_accno} : $form->{fxloss_accno};
#	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
#		    transdate, fx_transaction, cleared)
#		    VALUES ($form->{id}, (SELECT id FROM chart
#					  WHERE accno = '$accno'),
#		    $amount, '$form->{"datepaid_$i"}', '1', '1')|;
#	$dbh->do($query) || $form->dberror($query);
      }

      # update exchangerate record
      if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
	$form->update_exchangerate($dbh, $form->{currency}, $form->{"datepaid_$i"}, $form->{"exchangerate_$i"}, 0);
      }
    }
  }


  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}



sub delete_transaction {
  my ($self, $myconfig, $form) = @_;

  # connect to database, turn AutoCommit off
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check for other foreign currency transactions
  $form->delete_exchangerate($dbh) if ($form->{currency} ne $form->{defaultcurrency});

  my $query = qq|DELETE FROM debitnote WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);

  $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);

  # commit
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}



sub process_payments {
  my ($self, $myconfig, $form) = @_;
    
  # connect to database, turn AutoCommit off
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $amount, $exchangerate);

  # go through line by line and compare
  for my $i (1 .. $form->{rowcount}) {
    ($form->{"accno_$i"}) = split /--/, $form->{"accno_$i"};

    $form->{"paid_$i"} = $form->parse_amount($myconfig, $form->{"paid_$i"});
    
    if ($form->{"datepaid_$i"} && $form->{"paid_$i"} != 0) {
      
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{"iexch_$i"}, 2);
      
      # add AR
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate, amount)
                  VALUES ($form->{"id_$i"}, (SELECT id FROM chart
		                             WHERE accno = '$form->{"AR_$i"}'),
		  '$form->{"datepaid_$i"}', $amount)|;
      $dbh->do($query) || $form->dberror($query);
      
      $form->{"paid_$i"} *= -1;
      # add payment
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate, amount,
                  source)
                  VALUES ($form->{"id_$i"},
		         (SELECT id FROM chart
		          WHERE accno = '$form->{"accno_$i"}'),
		  '$form->{"datepaid_$i"}', $form->{"paid_$i"},
		  '$form->{"source_$i"}')|;
      $dbh->do($query) || $form->dberror($query);

      $exchangerate = 0;
      
      # add exchangerate difference if currency ne defaultcurrency
      if ($form->{"currency_$i"} eq $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = 1;
      } else {
	# check exchangerate
	$exchangerate = $form->check_exchangerate($myconfig, $form->{"currency_$i"}, $form->{"datepaid_$i"}, 'buy');

	$form->{"exchangerate_$i"} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{"exchangerate_$i"});
      }

      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{"exchangerate_$i"} - 1), 2);

      if ($amount != 0) {
        # exchangerate difference
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate,
		    amount, cleared, fx_transaction)
		    VALUES ($form->{"id_$i"},
		           (SELECT id FROM chart
			    WHERE accno = '$form->{"accno_$i"}'),
		  '$form->{"datepaid_$i"}', $amount, '1', '1')|;
	$dbh->do($query) || $form->dberror($query);

        # gain/loss
	$amount = $form->round_amount($form->{"paid_$i"} * ($form->{"iexch_$i"} - $form->{"exchangerate_$i"}), 2);
	$accno = ($amount > 0) ? $form->{fxgain_accno} : $form->{fxloss_accno};
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate,
		    amount, cleared, fx_transaction)
		    VALUES ($form->{"id_$i"}, (SELECT id FROM chart
					       WHERE accno = '$accno'),
		    '$form->{"datepaid_$i"}', $amount, '1', '1')|;
	$dbh->do($query) || $form->dberror($query);
      }

      # update exchangerate
      if (($form->{"currency_$i"} ne $form->{defaultcurrency}) && !$exchangerate) {
	$form->update_exchangerate($dbh, $form->{"currency_$i"}, $form->{"datepaid_$i"}, $form->{"exchangerate_$i"}, 0);
      }

      $form->{"totalpaid_$i"} += $form->{"paid_$i"} * -1;
      $form->{"totalpaid_$i"} = $form->round_amount($form->{"totalpaid_$i"} * $form->{"iexch_$i"}, 2);
      
      # update AR transaction
      $query = qq|UPDATE ar set
		  paid = $form->{"totalpaid_$i"},
		  datepaid = '$form->{"datepaid_$i"}'
		  WHERE id = $form->{"id_$i"}|;
      $dbh->do($query) || $form->dberror($query);
    }
  }
  
  $dbh->commit;
  $dbh->disconnect;

}



sub ar_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT a.id, a.invnumber, a.ordnumber, a.transdate,
                 a.duedate, a.netamount, a.amount, a.paid, c.name,
		 a.invoice, a.datepaid, a.terms, a.notes
	         FROM ar a, customer c
	         WHERE a.customer_id = c.id|;

  my $invnumber = $form->like(lc $form->{invnumber});
  my $ordnumber = $form->like(lc $form->{ordnumber});
  my $notes = $form->like(lc $form->{notes});
    
  $query .= " AND lower(a.invnumber) LIKE '$invnumber'" if $form->{invnumber};
  $query .= " AND lower(a.ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= " AND lower(a.notes) LIKE '$notes'" if $form->{notes};
  $query .= " AND a.customer_id = $form->{customer_id}" if ($form->{customer_id});
  $query .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};
  if ($form->{open} || $form->{closed}) {
    unless ($form->{open} && $form->{closed}) {
    $query .= " AND a.amount <> a.paid" if ($form->{open});
    $query .= " AND a.amount = a.paid" if ($form->{closed});
    }
  }

  my $sortorder = join ', ', $form->sort_columns(qw(transdate invnumber name));
  $sortorder = $form->{sort} unless $sortorder;
    
  $query .= " ORDER by $sortorder";
  
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ar = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{AR} }, $ar;
  }
  
  $sth->finish;
  $dbh->disconnect;

}



sub payments {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get paid accounts from chart
  my $query = qq|SELECT accno, description
                 FROM chart
	         WHERE link LIKE '%AR_paid%'|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $ar;
  while ($ar = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{paidaccount}{$ar->{accno}} = $ar;
  }
  $sth->finish;
    
  # get AR accounts from chart
  $query = qq|SELECT accno
              FROM chart
	      WHERE link LIKE '%AR%'
	      AND link NOT LIKE '%AR_%'|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while ($ar = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{AR_account}{$ar->{accno}} = $ar->{accno};
  }
  $sth->finish;
  
  # get fxgain and loss accounts
  $query = qq|SELECT curr, closedto,
       (SELECT accno FROM chart WHERE id = fxgain_accno_id) AS fxgain_accno,
       (SELECT accno FROM chart WHERE id = fxloss_accno_id) AS fxloss_accno
              FROM defaults|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  
  ($form->{defaultcurrency}, $form->{closedto}, $form->{fxgain_accno}, $form->{fxloss_accno}) = $sth->fetchrow_array;
  $sth->finish;
  
  $form->{defaultcurrency} =~ s/:.*//;

  $query = qq|SELECT a.id, a.invnumber, a.ordnumber, a.transdate, a.datepaid,
              a.amount, a.paid, c.name, a.invoice, a.curr AS currency
	      FROM ar a, customer c
	      WHERE a.customer_id = c.id|;

  my $invnumber = $form->like(lc $form->{invnumber});
  my $ordnumber = $form->like(lc $form->{ordnumber});
  
  $query .= " AND lower(a.invnumber) LIKE '$invnumber'" if $form->{invnumber};
  $query .= " AND lower(a.ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= " AND a.customer_id = $form->{customer_id}" if $form->{customer_id};
  $query .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};
  $query .= " AND a.amount <> a.paid" if ($form->{open} eq "Y");
  $query .= " ORDER by $form->{sort}";
  
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  
  while ($ar = $sth->fetchrow_hashref(NAME_lc)) {

    # get exchangerate
    $ar->{exchangerate} = $form->get_exchangerate($dbh, $ar->{currency}, $ar->{transdate}, "buy");
    
    # get data from acc_trans
    $query = qq|SELECT accno, amount, transdate, source, cleared
                FROM chart c, acc_trans a
		WHERE c.id = a.chart_id
		AND a.trans_id = $ar->{id}
		AND NOT a.fx_transaction = '1'
		ORDER BY transdate|;
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      # check if the accno matches a paid account
      if ($form->{paidaccount}{$ref->{accno}}) {
	$ref->{exchangerate} = $form->get_exchangerate($dbh, $ar->{currency}, $ref->{transdate}, "buy");
	push @{ $ar->{payments} }, $ref;
	next;
      }
      if ($form->{AR_account}{$ref->{accno}}) {
	$ar->{AR_account} = $ref->{accno};
      }
    }
    $sth->finish;

    push @{ $form->{AR} }, $ar;

  }
  
  $sth->finish;
  $dbh->disconnect;

}


sub transaction {
  my ($self, $myconfig, $form) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  if ($form->{id}) {
    $query = "SELECT closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
    $sth->finish;

    $query = "SELECT source, description, transdate,batch,project,subb
              FROM gl
	      WHERE id = $form->{id}";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{source}, $form->{description}, $form->{transdate}, $form->{batch}, $form->{project}, $form->{subb}) = $sth->fetchrow_array;
    $sth->finish;

    # retrieve individual rows
    $query = "SELECT chart.accno, amount
	      FROM acc_trans, chart
	      WHERE acc_trans.chart_id = chart.id and source != ''
	      AND trans_id = $form->{id}
	      ORDER BY amount";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      push @{ $form->{GL} }, $ref;
    }
  } else {
    $query = "SELECT current_date AS transdate, closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{transdate}, $form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
  }

  $sth->finish;

  # get chart of accounts
  $query = qq|SELECT accno,description
              FROM chart
	      WHERE charttype = 'A'
              ORDER by accno|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  $form->{chart} = "";
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{chart} .= "$ref->{accno}--$ref->{description}\n";
  }
  $sth->finish;

  $dbh->disconnect;

}
1;

