#!/usr/sbin/dtrace -qs

/*
 * USAGE      : lwlock_acquire_8.4.D <pid>
 *
 * DESCRIPTION:
 *   Show the number and total time of LWLock acquires by lock id and mode.
 *   The number of locks and names can be different from one release
 *   to another, so this script is only useful for Postgres 8.4.
 *
 * AUTHOR     : Robert Lor <robert.lor@sun.com
 *
 * $Header$
 */

dtrace:::BEGIN
{
	lckmode[0] = "Exclusive";
	lckmode[1] = "Shared";

	lckid[0] = "BufFreelistLock";
	lckid[1] = "ShmemIndexLock";
	lckid[2] = "OidGenLock";
	lckid[3] = "XidGenLock";
	lckid[4] = "ProcArrayLock";
	lckid[5] = "SInvalReadLock";
	lckid[6] = "SInvalWriteLock";
	lckid[7] = "WALInsertLock";
	lckid[8] = "WALWriteLock";
	lckid[9] = "ControlFileLock";
	lckid[10] = "CheckpointLock";
	lckid[11] = "CLogControlLock";
	lckid[12] = "SubtransControlLock";
	lckid[13] = "MultiXactGenLock";
	lckid[14] = "MultiXactOffsetControlLock";
	lckid[15] = "MultiXactMemberControlLock";
	lckid[16] = "RelCacheInitLock";
	lckid[17] = "BgWriterCommLock";
	lckid[18] = "TwoPhaseStateLock";
	lckid[19] = "TablespaceCreateLock";
	lckid[20] = "BtreeVacuumLock";
	lckid[21] = "AddinShemInitLock";
	lckid[22] = "AutovacuumLock";
	lckid[23] = "AutovacuumScheduleLock";
	lckid[24] = "SyncScanLock";
	lckid[25] = "FirstBufMappingLock";
	lckid[26] = "FirstLockMgrLock";

	endtime = timestamp + (5 * 1000000000ull);
}

postgresql$1:::lwlock-acquire
/arg0 < 27/
{
	self->ts[arg0]=timestamp; 
	@count[lckid[arg0], lckmode[arg1]] = count();
}

postgresql$1:::lwlock-release
/(arg0 < 27) && self->ts[arg0]/
{
    @time[lckid[arg0]] = sum (timestamp - self->ts[arg0]);
    self->ts[arg0]=0;
}

dtrace:::END {
        printf("\n%20s %15s %15s\n", "Lock Id", "Mode", "Count");
        printa("%20s %15s %@15d\n",@count);

        printf("\n%20s %20s\n", "Lock Id", "Combined Time (ns)");
        printa("%20s %@20d\n",@time);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
        exit(0);
}
