#!/usr/sbin/dtrace -qs

/*
 * Usage      : lwlock_wait.d <pid>
 * Description: Show number and total time of LWLock waits by lock id and mode.
 *              The number of locks and names can be different from one release
 *              to another, so this script is only useful for Postgres 8.4.
 * Author     : Robert Lor
 */

dtrace:::BEGIN
{
	lckmode[0] = "Exclusive";
	lckmode[1] = "Shared";

	lckid[0] = "BufFreelistLock";
	lckid[1] = "ShmemIndexLock";
	lckid[2] = "OidGenLock";
	lckid[3] = "XidGenLock";
	lckid[4] = "ProcArrayLock";
	lckid[5] = "SInvalReadLock";
	lckid[6] = "SInvalWriteLock";
	lckid[7] = "UnusedLock1";
	lckid[8] = "WALInsertLock";
	lckid[9] = "WALWriteLock";
	lckid[10] = "ControlFileLock";
	lckid[11] = "CheckpointLock";
	lckid[12] = "CLogControlLock";
	lckid[13] = "SubtransControlLock";
	lckid[14] = "MultiXactGenLock";
	lckid[15] = "MultiXactOffsetControlLock";
	lckid[16] = "MultiXactMemberControlLock";
	lckid[17] = "RelCacheInitLock";
	lckid[18] = "BgWriterCommLock";
	lckid[19] = "TwoPhaseStateLock";
	lckid[20] = "TablespaceCreateLock";
	lckid[21] = "BtreeVacuumLock";
	lckid[22] = "AddinShemInitLock";
	lckid[23] = "AutovacuumLock";
	lckid[24] = "AutovacuumScheduleLock";
	lckid[25] = "SyncScanLock";
	lckid[26] = "FirstBufMappingLock";
	lckid[27] = "FirstLockMgrLock";

	endtime = timestamp + (5 * 1000000000ull);
}

postgresql$1:::lwlock-wait-start
/arg0 < 28/
{
	self->ts[arg0]=timestamp; 
	@count[lckid[arg0], lckmode[arg1]] = count();
}

postgresql$1:::lwlock-wait-done
/(arg0 < 28) && self->ts[arg0]/
{
    @time[lckid[arg0],lckmode[arg1]] = sum (timestamp - self->ts[arg0]);
    self->ts[arg0]=0;
}

dtrace:::END {
        printf("\n%20s %15s %15s\n", "Lock Id", "Mode", "Count");
        printa("%20s %15s %@15d\n",@count);

        printf("\n%20s %15s %20s\n", "Lock Id","Mode", "Combined Time (ns)");
        printa("%20s %15s %@20d\n",@time);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
        exit(0);
}
