#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <net/ethernet.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <sys/time.h>
#include <pthread.h>
#include <unistd.h>

#include <iostream>
#include <map>
#include <list>

#include <pcap.h>

using namespace std;

#include "ip.h"
#include "sll.h"
#include "prio.h"
#include "sqlwrite.h"

static void    *SaveDataThread(void *arg)
{
	RTable	*rt = (RTable *)arg;
	CRecordList	crl;

	for (;;) {
		rt->Sleep();
		struct timeval tv;
		bool seen = false;

		gettimeofday(&tv, NULL);
		tv.tv_sec -= 2;
		rt->MakeListOfFlushItems(&crl, &tv);
		for (CRecordListIter iter = crl.begin(); iter != crl.end(); ) {
			CRecordListIter prev = iter;
			CRecord *cr = *iter++;
			cout << cr;
			SQlSaveRecord(cr);
			seen = true;
			crl.erase(prev);
			delete cr;
		}
		if (seen) 
			SQLCommit();
	}
}


u_char *handle_IP(u_char *args, const struct pcap_pkthdr *pkthdr, const u_char * packet, int hrdSize)
{
  const struct my_ip *ip;
  u_int length = pkthdr->len;
  u_int hlen, off, version;
  int i;

  int len;

/* jump pass the ethernet header */
  ip = (struct my_ip *)(packet + hrdSize);
  length -= hrdSize;

/* check to see we have a packet of valid length */
	if (length < sizeof (struct my_ip)) {
		cerr << "truncated ip " << length << endl;
		return NULL;

	}

	len = ntohs(ip->ip_len);
	hlen = IP_HL(ip);		/* header length */
	version = IP_V(ip);		/* ip version */

	/* check version */
	if (version != 4) {
		cerr << "unsupported IP version " << version << endl;
		return NULL;
	}

	/* check header length */
	if (hlen < 5) {
		cerr << "bad-hlen " << hlen << endl;
		return NULL;
	}

	/* see if we have as much packet as we should */
	if (length < len) {
		cerr << "truncated IP - " <<  len - length << " bytes missing" << endl;
		return NULL;
	}

	RTable  *rt = (RTable *)args;

	CRecord	cr(ip, pkthdr->len);
	rt->Add(&cr, pkthdr->ts);
	return NULL;
}

#ifndef ETHER_HDRLEN
#define ETHER_HDRLEN 14
#endif

void my_callback(u_char *args, const struct pcap_pkthdr *pkthdr, const u_char *packet)
{
	RTable *rt = (RTable *)args;
	u_int caplen = pkthdr->caplen;
	u_int length = pkthdr->len;

	switch (rt->Get_DataLinkType()) {
	case DLT_PPP:
		cout << "ppp packet" << endl;
		break;

	case DLT_LINUX_SLL: {
			const struct sll_header *sllp = (const struct sll_header *)packet;
			u_short ether_type = ntohs(sllp->sll_protocol);
			switch (ether_type) {
			case ETHERTYPE_IP: {
					handle_IP(args, pkthdr, packet, SLL_HDR_LEN);
					break;
				}
			default:
				cerr << "unhandled ETHERTYPE: 0" << endl;
				break;
			}
		}
		break;


	case DLT_EN10MB: {
			const struct ether_header *eptr = (const struct ether_header *)packet;
			u_int16_t type = ntohs(eptr->ether_type);

			if (caplen < ETHER_HDRLEN) {
				cerr << "Packet length less than ethernet header length" << endl;
				return;
			}
			switch (type) {
			case 0:
				cerr << "unhandled ETHERTYPE: 0" << endl;
				break;
			case ETHERTYPE_IP:
				handle_IP(args, pkthdr, packet, sizeof (struct ether_header));
				break;
			case ETHERTYPE_ARP:
				break;
			case ETHERTYPE_REVARP:
				break;
			default:
				break;
			}
		}
		break;
	default:
		cout << "unknown data link layer type " << rt->Get_DataLinkType() << endl;
		break;
	}
}


int main(int argc, char *argv[])
{
    int nerr;
    pthread_t	tid;
    RTable   *rt;

	char *dev = (char *)0;
	char errbuf[PCAP_ERRBUF_SIZE];

	int	opt;
	int	sltime = 10;
	int	numPackets = 10;
	char	*connectionString = "usage@localhost";
	char	*filter = NULL;

	while ((opt = getopt(argc, argv, "p:c:f:d:i:")) != -1) {
		switch (opt) {
		case 's':
			sltime = atoi(optarg);
			break;
		case 'p':
			numPackets = atoi(optarg);
			break;
		case 'c':
			connectionString = optarg;
			break;
		case 'f':
			filter = optarg;
			break;
		case 'd':
		case 'i':
			dev = optarg;
			break;
		default:
			cerr << "invalid usage" << endl;
			exit(1);
		}
	}
	SQLConnect(connectionString);
	if (dev == (char *)0) {
		if ((dev = pcap_lookupdev(errbuf)) == (char *)0) {
			cerr << "pcap_lookupdev failed: " << errbuf << endl;
			exit(1);
		}
	}
	cout << "capturing on " << dev << endl;

	bpf_u_int32 maskp;    /* subnet mask   */
	bpf_u_int32 netp;     /* ip   */           
	pcap_t *descr;			/* pcap descriptor */

	if (pcap_lookupnet(dev, &netp, &maskp, errbuf) < 0) {
		cerr << "pcap_lookupnet(): " << errbuf << endl;
		exit(1);
	}
	if ((descr = pcap_open_live(dev, BUFSIZ, 1, -1, errbuf)) == (pcap_t *)0) {
		cerr << "pcap_open_live(): " << errbuf << endl;
		exit(1);
	}
	struct bpf_program compiledFilter;

	if (filter != NULL) {
		if (pcap_compile(descr, &compiledFilter, filter, 0, netp) == -1) {
			cerr << "Error calling pcap_compile" << endl;
			exit(1);
		}
		/* set the compiled program as the filter */
		if (pcap_setfilter(descr, &compiledFilter) == -1) {
			cerr << "Error setting filter" << endl;
			exit(1); 
		} 
	}
	cout << "datalink is " << pcap_datalink(descr) << endl;
	rt = new RTable(sltime, pcap_datalink(descr));

    if (pthread_create(&tid, NULL, SaveDataThread, (void *)rt) < 0) {
		perror("pthread_create");
		exit(1);
    }

	pcap_loop(descr, numPackets, my_callback, (u_char *)rt);
	
	struct pcap_stat ps;

	if (pcap_stats(descr, &ps) < 0) {
		cerr << "pcap_stats failed: " << pcap_geterr(descr) << endl;
		exit(1);
	}
	cout << ps.ps_recv << " received" << endl;
	cout << ps.ps_drop << " dropped" << endl;
	sleep(sltime + 2);
	cout << "AT END" << endl << *rt << endl;
	return 0;
}


#if 1


class DnsRecord {
	struct in_addr ip;
	int	serial_m;
	datetime last_access;
};


typedef list<DnsRecord *> DnsRecordList;
typedef DnsRecordList::iterator DnsRecordListIter;
typedef map<string hostName, DnsRecordList *dnsrl> DnsRecordListMap;
typedef DnsRecordMap::iterator DnsRecordMapIter;

	get hostname
	lookup host


class DnsCache {
	DnsRecordMap	ipToRecord_m;
public:
	cleanold
		in background thread, once every now and then, step through the dns list and remove
		any items that have not been accessed in X days
	// find the host from the IP and return the IP serial number
	int	FindHostFromIP(struct in_addr ip) {
		char			buf[8192];  make non local or malloc
		uint32_t addr;
		struct hostent  hpb;
		struct hostent *hp;

		// gethost by name
		if ((res = gethostbyaddr_r((char *)&ip, sizeof (struct in_addr),
									 AF_INET, 
									 &hpb,
									 buf, sizeof(buf),
									 &hp, &err)) != 0) 
			if (errno == ENOENT) {
				cerr << "not found" << endl;
			} else {
				perror("gethostbyaddr_r: ");
			}
			return 0;
		} 
		string	resolvedName = hp->h_name;
		// lock here?
		// look up host in local map without serial to get 
		DnsRecordMapIter		dnsRec = ipToRecord_m.find(resolvedName);

		if (dnsRec != ipToRecord_m.end()) {
			DnsRecord *dnsr = dnsRec.second;
			if (dnsr->ip->s_addr == ip->s_addr) {
				return serial from map and hostname, the rest should work out as the IP is in the record
					and the correct hostname and ip are in the table and written somewhere else
			else
				// hostname not the same
				create new record with old ip, old serial + 1 and new host name
				delete old one from the list
				// SAME as below
				add the new one to the list
				insert the new one into the database
			in both cases updated last_access to now
				create an ordered last access list?
		} else { // not found
			// look it up int the database
			create new record from hostname and ip with serial of 0
			/SAME as below
			add to the list
			inset into database
		

}
	

#endif
