/* Processed by ecpg (2.11.0) */
/* These four include files are added by the preprocessor */
#include <ecpgtype.h>
#include <ecpglib.h>
#include <ecpgerrno.h>
#include <sqlca.h>
#line 1 "sqlwrite.ec"
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <net/ethernet.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <sys/time.h>

#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>

using namespace std;


#include "ip.h"
#include "prio.h"


#line 1 "/usr/local/postgres/include/sqlca.h"
#ifndef POSTGRES_SQLCA_H
#define POSTGRES_SQLCA_H

#ifndef DLLIMPORT
#ifdef __CYGWIN__
#define DLLIMPORT __declspec (dllimport)
#else
#define DLLIMPORT
#endif   /* __CYGWIN__ */
#endif   /* DLLIMPORT */

#define SQLERRMC_LEN	70

#ifdef __cplusplus
extern		"C"
{
#endif

struct sqlca
{
	char		sqlcaid[8];
	long		sqlabc;
	long		sqlcode;
	struct
	{
		int			sqlerrml;
		char		sqlerrmc[SQLERRMC_LEN];
	}			sqlerrm;
	char		sqlerrp[8];
	long		sqlerrd[6];
	/* Element 0: empty						*/
	/* 1: OID of processed tuple if applicable			*/
	/* 2: number of rows processed				*/
	/* after an INSERT, UPDATE or				*/
	/* DELETE statement					*/
	/* 3: empty						*/
	/* 4: empty						*/
	/* 5: empty						*/
	char		sqlwarn[8];
	/* Element 0: set to 'W' if at least one other is 'W'	*/
	/* 1: if 'W' at least one character string		*/
	/* value was truncated when it was			*/
	/* stored into a host variable.				*/

	/*
	 * 2: if 'W' a (hopefully) non-fatal notice occured
	 */	/* 3: empty */
	/* 4: empty						*/
	/* 5: empty						*/
	/* 6: empty						*/
	/* 7: empty						*/

	char		sqlext[8];
};

extern DLLIMPORT struct sqlca sqlca;


#ifdef __cplusplus
}
#endif

#endif

#line 25 "sqlwrite.ec"


void	SQLConnect(char *connectionInfo)
{
	/* exec sql begin declare section */
		
	
#line 30 "sqlwrite.ec"
   char * connection   ;
/* exec sql end declare section */
#line 31 "sqlwrite.ec"


	connection = connectionInfo;

	{ ECPGconnect(__LINE__, connection , NULL,NULL , NULL, 0); }
#line 35 "sqlwrite.ec"

	if(sqlca.sqlcode) {
		fprintf(stderr, "error connecting to database\n");
		exit(0);
	}
#if 1
	else 
		cout << "connection to " << connectionInfo << " OK" << endl;
#endif
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}

static int	records;

void	SQlSaveRecord(CRecord *cr)
{
	/* exec sql begin declare section */
	  
		
		
	 	
		
	 	
		
		
	  
	
#line 60 "sqlwrite.ec"
   char  f_ip_src [ 16 ]   ;
 
#line 61 "sqlwrite.ec"
   char  f_ip_dst [ 16 ]   ;
 
#line 62 "sqlwrite.ec"
   int  f_port_src   ;
 
#line 63 "sqlwrite.ec"
   int  f_port_dst   ;
 
#line 64 "sqlwrite.ec"
   int  f_ip_proto   ;
 
#line 65 "sqlwrite.ec"
   int  f_volume   ;
 
#line 66 "sqlwrite.ec"
   int  f_packets   ;
 
#line 67 "sqlwrite.ec"
   char  f_lastUpdate [ 30 ]   ;
 
#line 68 "sqlwrite.ec"
   char  f_firstUpdate [ 30 ]   ;
/* exec sql end declare section */
#line 69 "sqlwrite.ec"


	strcpy(f_ip_src, inet_ntoa(cr->ip_src_m));
	strcpy(f_ip_dst, inet_ntoa(cr->ip_dst_m));
	f_port_src = cr->port_src_m;
	f_port_dst = cr->port_dst_m;
	f_ip_proto = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	timevalToDate(&cr->lastUpdate_m, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_m, f_firstUpdate);

	{ ECPGdo(__LINE__, NULL, "insert into usage ( ip_src  , ip_dst  , port_src  , port_dst  , number  , first_seen  , last_seen  , packets  , volume  ) values ( ? , ? , ? , ? , ? , ? , ? , ? , ? )", 
	ECPGt_char,(f_ip_src),16L,1L,16*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_ip_dst),16L,1L,16*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_src),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_dst),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_ip_proto),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_firstUpdate),30L,1L,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_lastUpdate),30L,1L,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_packets),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_volume),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EOIT, ECPGt_EORT);}
#line 89 "sqlwrite.ec"

	if (sqlca.sqlcode != 0) {		printf("Error #%d: %s\n", sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		exit(1);
	}
	records++;
}


void	SQLCommit()
{
	{ ECPGtrans(__LINE__, NULL, "commit");}
#line 100 "sqlwrite.ec"

	cerr << "commit " << records << endl;
	records = 0;
}
