
struct CRecord {
    struct in_addr  ip_src_m;
    struct in_addr  ip_dst_m;
    u_int16_t port_src_m;
    u_int16_t port_dst_m;
    u_int8_t ip_proto_m;
    int volume_m;
	 int packets_m;
    struct timeval lastUpdate_m;
    struct timeval firstUpdate_m;

    CRecord(const struct my_ip *ip, int volume);

    friend ostream& operator<<(ostream &os, const CRecord *cr);
};


struct CompareCRecord  {
    bool operator()(const CRecord *s1, const CRecord* s2) const {
		in_addr_t src1 = s1->ip_src_m.s_addr;
		in_addr_t dest1 = s1->ip_dst_m.s_addr;
		in_addr_t src2 = s2->ip_src_m.s_addr;
		in_addr_t dest2 = s2->ip_dst_m.s_addr;

		if (src1 == src2) {
			if (dest1 == dest2) {
				if (s1->port_src_m == s2->port_src_m) {
					if (s1->port_dst_m == s2->port_dst_m) {
						return s1->ip_proto_m < s2->ip_proto_m;
					} else {
						return s1->port_dst_m < s2->port_dst_m;
					}
				} else {
					return s1->port_src_m < s2->port_src_m;
				}
			} else {
				return dest1 < dest2;
			}
		} else {
			return src1 < src2;
		}
    }
};

typedef list<CRecord *> CRecordList;
typedef CRecordList::iterator	CRecordListIter;

// map of a partially filled in CRecord to the one in the list
typedef map<CRecord *,	CRecordListIter, CompareCRecord> CRecordMap;
typedef CRecordMap::iterator CRecordMapIter;

class RTable {
	CRecordMap	crm;
	CRecordList	crl_m;
	int		SleepTime_m;
	pthread_mutex_t mutex_m;
	int	dataLinkType_m;
public:
	RTable(int SleepTime, int dataLinkType);
	void	Add(CRecord *cr, struct timeval when);
	void	MakeListOfFlushItems(CRecordList *ulist, struct timeval *since);
	void	Sleep();
	int	Get_DataLinkType() {
		return dataLinkType_m;
	}

	friend ostream& operator<<(ostream &os, RTable& rtt);
};


extern ostream& operator<<(ostream &os, struct timeval tv);
