'
'	Frank Lupo (Wolf) !!
'	Frank_lupo@email.it

'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Help SQL for postgres version : 7_1_3
'
Option Explicit

Class ClsHelpVersion

	Public Function ReturnHelp()
	Dim HelpCommad
		Set HelpCommad = CreateObject("Scripting.Dictionary")

		HelpCommad.Add "ABORT", _
			Array("Aborts the current transaction", _
				"ABORT [ WORK | TRANSACTION ]" )

		HelpCommad.Add "ALTER GROUP", _
			Array("Add users to a group, remove users from a group", _
				"ALTER GROUP name ADD USER username [, ... ]" & vbcrlf & _
				"ALTER GROUP name DROP USER username [, ... ]" )

		HelpCommad.Add "ALTER TABLE", _
			Array("Modifies table properties", _
				"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    ADD [ COLUMN ] column type" & vbcrlf & _
				"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    ALTER [ COLUMN ] column { SET DEFAULT value | DROP DEFAULT }" & vbcrlf & _
				"ALTER TABLE table [ * ]" & vbcrlf & _
				"    RENAME [ COLUMN ] column TO newcolumn" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"    RENAME TO newtable" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"    ADD table constraint definition" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"	OWNER TO new owner " )

		HelpCommad.Add "ALTER USER", _
			Array("Modifies user account information", _
				"ALTER USER username" & vbcrlf & _
				"    [ WITH PASSWORD 'password' ]" & vbcrlf & _
				"    [ CREATEDB | NOCREATEDB ] [ CREATEUSER | NOCREATEUSER ]" & vbcrlf & _
				"    [ VALID UNTIL 'abstime' ]" )

		HelpCommad.Add "BEGIN", _
			Array("Begins a transaction in chained mode", _
				"BEGIN [ WORK | TRANSACTION ]" )

		HelpCommad.Add "CHECKPOINT", _
			Array("Force transaction log checkpoint", _
				"CHECKPOINT" )

		HelpCommad.Add "CLOSE", _
			Array("Close a cursor", _
				"CLOSE cursor" )

		HelpCommad.Add "CLUSTER", _
			Array("Gives storage clustering advice to the server", _
				"CLUSTER indexname ON tablename" )

		HelpCommad.Add "COMMENT", _
			Array("Add comment to an object", _
				"COMMENT ON" & vbcrlf & _
				"[" & vbcrlf & _
				"  [ DATABASE | INDEX | RULE | SEQUENCE | TABLE | TYPE | VIEW ]" & vbcrlf & _
				"  object_name |" & vbcrlf & _
				"  COLUMN table_name.column_name|" & vbcrlf & _
				"  AGGREGATE agg_name agg_type|" & vbcrlf & _
				"  FUNCTION func_name (arg1, arg2, ...)|" & vbcrlf & _
				"  OPERATOR op (leftoperand_type rightoperand_type) |" & vbcrlf & _
				"  TRIGGER trigger_name ON table_name" & vbcrlf & _
				"] IS 'text'" )

		HelpCommad.Add "COMMIT", _
			Array("Commits the current transaction", _
				"COMMIT [ WORK | TRANSACTION ]" )

		HelpCommad.Add "COPY", _
			Array("Copies data between files and tables", _
				"COPY [ BINARY ] table [ WITH OIDS ]" & vbcrlf & _
				"    FROM { 'filename' | stdin }" & vbcrlf & _
				"    [ [USING] DELIMITERS 'delimiter' ]" & vbcrlf & _
				"    [ WITH NULL AS 'null string' ]" & vbcrlf & _
				"COPY [ BINARY ] table [ WITH OIDS ]" & vbcrlf & _
				"    TO { 'filename' | stdout }" & vbcrlf & _
				"    [ [USING] DELIMITERS 'delimiter' ]" & vbcrlf & _
				"    [ WITH NULL AS 'null string' ]" )

		HelpCommad.Add "CREATE AGGREGATE", _
			Array("Defines a new aggregate function", _
				"CREATE AGGREGATE name ( BASETYPE = input_data_type," & vbcrlf & _
				"    SFUNC = sfunc, STYPE = state_type" & vbcrlf & _
				"    [ , FINALFUNC = ffunc ]" & vbcrlf & _
				"    [ , INITCOND = initial_condition ] )" )

		HelpCommad.Add "CREATE CONSTRAINT TRIGGER", _
			Array("Create a trigger to support a constraint", _
				"CREATE CONSTRAINT TRIGGER name" & vbcrlf & _
				"    AFTER events ON" & vbcrlf & _
				"    relation constraint attributes" & vbcrlf & _
				"    FOR EACH ROW EXECUTE PROCEDURE func '(' args ')'" )

		HelpCommad.Add "CREATE DATABASE", _
			Array("Creates a new database", _
				"CREATE DATABASE name" & vbcrlf & _
				"    [ WITH [ LOCATION = 'dbpath' ]" & vbcrlf & _
				"           [ TEMPLATE = template ]" & vbcrlf & _
				"           [ ENCODING = encoding ] ]" )

		HelpCommad.Add "CREATE FUNCTION", _
			Array("Defines a new function", _
				"CREATE FUNCTION name ( [ ftype [, ...] ] )" & vbcrlf & _
				"    RETURNS rtype" & vbcrlf & _
				"    AS definition   " & vbcrlf & _
				"    LANGUAGE 'langname'" & vbcrlf & _
				"    [ WITH ( attribute [, ...] ) ]" & vbcrlf & _
				"CREATE FUNCTION name ( [ ftype [, ...] ] )" & vbcrlf & _
				"    RETURNS rtype" & vbcrlf & _
				"    AS obj_file , link_symbol  " & vbcrlf & _
				"    LANGUAGE 'langname'" & vbcrlf & _
				"    [ WITH ( attribute [, ...] ) ]" )

		HelpCommad.Add "CREATE GROUP", _
			Array("Creates a new group", _
				"CREATE GROUP name" & vbcrlf & _
				"    [ WITH " & vbcrlf & _
				"     [ SYSID gid ]" & vbcrlf & _
				"     [ USER  username [, ...] ] ]" )

		HelpCommad.Add "CREATE INDEX", _
			Array("Constructs a secondary index", _
				"CREATE [ UNIQUE ] INDEX index_name ON table" & vbcrlf & _
				"    [ USING acc_name ] ( column [ ops_name ] [, ...] )" & vbcrlf & _
				"CREATE [ UNIQUE ] INDEX index_name ON table" & vbcrlf & _
				"    [ USING acc_name ] ( func_name( column [, ... ]) [ ops_name ] )" )

		HelpCommad.Add "CREATE LANGUAGE", _
			Array("Defines a new language for functions", _
				"CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE 'langname'" & vbcrlf & _
				"    HANDLER call_handler" & vbcrlf & _
				"    LANCOMPILER 'comment'" )

		HelpCommad.Add "CREATE OPERATOR", _
			Array("Defines a new user operator", _
				"CREATE OPERATOR name ( PROCEDURE = func_name" & vbcrlf & _
				"     [, LEFTARG = type1 ] [, RIGHTARG = type2 ]" & vbcrlf & _
				"     [, COMMUTATOR = com_op ] [, NEGATOR = neg_op ]" & vbcrlf & _
				"     [, RESTRICT = res_proc ] [, JOIN = join_proc ]" & vbcrlf & _
				"     [, HASHES ] [, SORT1 = left_sort_op ] [, SORT2 = right_sort_op ] )" )

		HelpCommad.Add "CREATE RULE", _
			Array("Defines a new rule", _
				"CREATE RULE name AS ON event" & vbcrlf & _
				"    TO object [ WHERE condition ]" & vbcrlf & _
				"    DO [ INSTEAD ] action" & vbcrlf & _
				"" & vbcrlf & _
				"where action can be:" & vbcrlf & _
				"" & vbcrlf & _
				"NOTHING" & vbcrlf & _
				"|" & vbcrlf & _
				"query" & vbcrlf & _
				"|" & vbcrlf & _
				"( query ; query ... )" & vbcrlf & _
				"|" & vbcrlf & _
				"[ query ; query ... ]" )

		HelpCommad.Add "CREATE SEQUENCE", _
			Array("Creates a new sequence number generator", _
				"CREATE SEQUENCE seqname [ INCREMENT increment ]" & vbcrlf & _
				"    [ MINVALUE minvalue ] [ MAXVALUE maxvalue ]" & vbcrlf & _
				"    [ START start ] [ CACHE cache ] [ CYCLE ]" )

		HelpCommad.Add "CREATE TABLE", _
			Array("Creates a new table", _
				"CREATE [ TEMPORARY | TEMP ] TABLE table_name (" & vbcrlf & _
				"    { column_name type [ column_constraint [ ... ] ]" & vbcrlf & _
				"      | table_constraint }  [, ... ]" & vbcrlf & _
				"    ) [ INHERITS ( parent_table [, ... ] ) ]" & vbcrlf & _
				"" & vbcrlf & _
				"where column_constraint can be:" & vbcrlf & _
				"[ CONSTRAINT constraint_name ]" & vbcrlf & _
				"{ NOT NULL | NULL | UNIQUE | PRIMARY KEY | DEFAULT value | CHECK (condition) |" & vbcrlf & _
				"  REFERENCES table [ ( column ) ] [ MATCH FULL | MATCH PARTIAL ]" & vbcrlf & _
				"   [ ON DELETE action ] [ ON UPDATE action ]" & vbcrlf & _
				"   [ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]" & vbcrlf & _
				"}" & vbcrlf & _
				"" & vbcrlf & _
				"and table_constraint can be:" & vbcrlf & _
				"[ CONSTRAINT constraint_name ]" & vbcrlf & _
				"{ UNIQUE ( column_name [, ... ] ) |" & vbcrlf & _
				"  PRIMARY KEY ( column_name [, ... ] ) |" & vbcrlf & _
				"  CHECK ( condition ) |" & vbcrlf & _
				"  FOREIGN KEY ( column_name [, ... ] ) REFERENCES table [ ( column [, ... ] ) ]" & vbcrlf & _
				"   [ MATCH FULL | MATCH PARTIAL ] [ ON DELETE action ] [ ON UPDATE action ]" & vbcrlf & _
				"   [ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]" & vbcrlf & _
				"}" )

		HelpCommad.Add "CREATE TABLE AS", _
			Array("Creates a new table from the results of a SELECT", _
				"CREATE [ TEMPORARY | TEMP ] TABLE table [ (column [, ...] ) ]" & vbcrlf & _
				"     AS select_clause" )

		HelpCommad.Add "CREATE TRIGGER", _
			Array("Creates a new trigger", _
				"CREATE TRIGGER name { BEFORE | AFTER } { event [OR ...] }" & vbcrlf & _
				"    ON table FOR EACH { ROW | STATEMENT }" & vbcrlf & _
				"    EXECUTE PROCEDURE func ( arguments )" )

		HelpCommad.Add "CREATE TYPE", _
			Array("Defines a new base data type", _
				"CREATE TYPE typename ( INPUT = input_function, OUTPUT = output_function" & vbcrlf & _
				"      , INTERNALLENGTH = { internallength | VARIABLE }" & vbcrlf & _
				"    [ , EXTERNALLENGTH = { externallength | VARIABLE } ]" & vbcrlf & _
				"    [ , DEFAULT = ""default"" ]" & vbcrlf & _
				"    [ , ELEMENT = element ] [ , DELIMITER = delimiter ]" & vbcrlf & _
				"    [ , SEND = send_function ] [ , RECEIVE = receive_function ]" & vbcrlf & _
				"    [ , PASSEDBYVALUE ]" & vbcrlf & _
				"    [ , ALIGNMENT = alignment ]" & vbcrlf & _
				"    [ , STORAGE = storage ]" & vbcrlf & _
				")" )

		HelpCommad.Add "CREATE USER", _
			Array("Creates a new database user", _
				"CREATE USER username" & vbcrlf & _
				"    [ WITH" & vbcrlf & _
				"     [ SYSID uid ]" & vbcrlf & _
				"     [ PASSWORD 'password' ] ]" & vbcrlf & _
				"    [ CREATEDB   | NOCREATEDB ] [ CREATEUSER | NOCREATEUSER ]" & vbcrlf & _
				"    [ IN GROUP     groupname [, ...] ]" & vbcrlf & _
				"    [ VALID UNTIL  'abstime' ]" )

		HelpCommad.Add "CREATE VIEW", _
			Array("Constructs a virtual table", _
				"CREATE VIEW view AS SELECT query" )

		HelpCommad.Add "DECLARE", _
			Array("Defines a cursor for table access", _
				"DECLARE cursorname [ BINARY ] [ INSENSITIVE ] [ SCROLL ]" & vbcrlf & _
				"    CURSOR FOR query" & vbcrlf & _
				"    [ FOR { READ ONLY | UPDATE [ OF column [, ...] ] ]" )

		HelpCommad.Add "DELETE", _
			Array("Removes rows from a table", _
				"DELETE FROM [ ONLY ] table [ WHERE condition ]" )

		HelpCommad.Add "DROP AGGREGATE", _
			Array("Removes the definition of an aggregate function", _
				"DROP AGGREGATE name type" )

		HelpCommad.Add "DROP DATABASE", _
			Array("Removes an existing database", _
				"DROP DATABASE name" )

		HelpCommad.Add "DROP FUNCTION", _
			Array("Removes a user-defined C function", _
				"DROP FUNCTION name ( [ type [, ...] ] )" )

		HelpCommad.Add "DROP GROUP", _
			Array("Removes a group", _
				"DROP GROUP name" )

		HelpCommad.Add "DROP INDEX", _
			Array("Removes existing indexes from a database", _
				"DROP INDEX index_name [, ...]" )

		HelpCommad.Add "DROP LANGUAGE", _
			Array("Removes a user-defined procedural language", _
				"DROP [ PROCEDURAL ] LANGUAGE 'name'" )

		HelpCommad.Add "DROP OPERATOR", _
			Array("Removes an operator from the database", _
				"DROP OPERATOR id ( lefttype | NONE , righttype | NONE )" )

		HelpCommad.Add "DROP RULE", _
			Array("Removes existing rules from the database", _
				"DROP RULE name [, ...]" )

		HelpCommad.Add "DROP SEQUENCE", _
			Array("Removes existing sequences from a database", _
				"DROP SEQUENCE name [, ...]" )

		HelpCommad.Add "DROP TABLE", _
			Array("Removes existing tables from a database", _
				"DROP TABLE name [, ...]" )

		HelpCommad.Add "DROP TRIGGER", _
			Array("Removes the definition of a trigger", _
				"DROP TRIGGER name ON table" )

		HelpCommad.Add "DROP TYPE", _
			Array("Removes user-defined types from the system catalogs", _
				"DROP TYPE typename [, ...]" )

		HelpCommad.Add "DROP USER", _
			Array("Removes a user", _
				"DROP USER name" )

		HelpCommad.Add "DROP VIEW", _
			Array("Removes existing views from a database", _
				"DROP VIEW name [, ...]" )

		HelpCommad.Add "END", _
			Array("Commits the current transaction", _
				"END [ WORK | TRANSACTION ]" )

		HelpCommad.Add "EXPLAIN", _
			Array("Shows statement execution plan", _
				"EXPLAIN [ VERBOSE ] query        " )

		HelpCommad.Add "FETCH", _
			Array("Gets rows using a cursor", _
				"FETCH [ direction ] [ count ] { IN | FROM } cursor" & vbcrlf & _
				"FETCH [ FORWARD | BACKWARD | RELATIVE ] [ # | ALL | NEXT | PRIOR ] { IN | FROM } cursor" )

		HelpCommad.Add "GRANT", _
			Array("Grants access privilege to a user, a group or all users", _
				"GRANT privilege [, ...] ON object [, ...]" & vbcrlf & _
				"    TO { PUBLIC | GROUP group | username }" )

		HelpCommad.Add "INSERT", _
			Array("Inserts new rows into a table", _
				"INSERT INTO table [ ( column [, ...] ) ]" & vbcrlf & _
				"    { DEFAULT VALUES | VALUES ( expression [, ...] ) | SELECT query }" )

		HelpCommad.Add "LISTEN", _
			Array("Listen for a response on a notify condition", _
				"LISTEN name" )

		HelpCommad.Add "LOAD", _
			Array("Dynamically loads an object file", _
				"LOAD 'filename'" )

		HelpCommad.Add "LOCK", _
			Array("Explicitly lock a table inside a transaction", _
				"LOCK [ TABLE ] name" & vbcrlf & _
				"LOCK [ TABLE ] name IN [ ROW | ACCESS ] { SHARE | EXCLUSIVE } MODE" & vbcrlf & _
				"LOCK [ TABLE ] name IN SHARE ROW EXCLUSIVE MODE" )

		HelpCommad.Add "MOVE", _
			Array("Moves cursor position", _
				"MOVE [ direction ] [ count ] " & vbcrlf & _
				"    { IN | FROM } cursor" )

		HelpCommad.Add "NOTIFY", _
			Array("Signals all frontends and backends listening on a notify condition", _
				"NOTIFY name        " )

		HelpCommad.Add "REINDEX", _
			Array("Recover corrupted system indexes under stand-alone Postgres", _
				"REINDEX { TABLE | DATABASE | INDEX } name [ FORCE ]" )

		HelpCommad.Add "RESET", _
			Array("Restores run-time parameters to default values", _
				"RESET variable" )

		HelpCommad.Add "REVOKE", _
			Array("Revokes access privilege from a user, a group or all users.", _
				"REVOKE privilege [, ...]" & vbcrlf & _
				"    ON object [, ...]" & vbcrlf & _
				"    FROM { PUBLIC | GROUP groupname | username }" )

		HelpCommad.Add "ROLLBACK", _
			Array("Aborts the current transaction", _
				"ROLLBACK [ WORK | TRANSACTION ]" )

		HelpCommad.Add "SELECT", _
			Array("Retrieves rows from a table or view", _
				"SELECT [ ALL | DISTINCT [ ON ( expression [, ...] ) ] ]" & vbcrlf & _
				"    * | expression [ AS output_name ] [, ...]" & vbcrlf & _
				"    [ FROM from_item [, ...] ]" & vbcrlf & _
				"    [ WHERE condition ]" & vbcrlf & _
				"    [ GROUP BY expression [, ...] ]" & vbcrlf & _
				"    [ HAVING condition [, ...] ]" & vbcrlf & _
				"    [ { UNION | INTERSECT | EXCEPT [ ALL ] } select ]" & vbcrlf & _
				"    [ ORDER BY expression [ ASC | DESC | USING operator ] [, ...] ]" & vbcrlf & _
				"    [ FOR UPDATE [ OF tablename [, ...] ] ]" & vbcrlf & _
				"    [ LIMIT { count | ALL } [ { OFFSET | , } start ]]" & vbcrlf & _
				"" & vbcrlf & _
				"where from_item can be:" & vbcrlf & _
				"" & vbcrlf & _
				"[ ONLY ] table_name [ * ]" & vbcrlf & _
				"    [ [ AS ] alias [ ( column_alias_list ) ] ]" & vbcrlf & _
				"|" & vbcrlf & _
				"( select )" & vbcrlf & _
				"    [ AS ] alias [ ( column_alias_list ) ]" & vbcrlf & _
				"|" & vbcrlf & _
				"from_item [ NATURAL ] join_type from_item" & vbcrlf & _
				"    [ ON join_condition | USING ( join_column_list ) ]" )

		HelpCommad.Add "SELECT INTO", _
			Array("Creates a new table from the results of a SELECT", _
				"SELECT [ ALL | DISTINCT [ ON ( expression [, ...] ) ] ]" & vbcrlf & _
				"    * | expression [ AS output_name ] [, ...]" & vbcrlf & _
				"    INTO [ TEMPORARY | TEMP ] [ TABLE ] new_table" & vbcrlf & _
				"    [ FROM from_item [, ...] ]" & vbcrlf & _
				"    [ WHERE condition ]" & vbcrlf & _
				"    [ GROUP BY expression [, ...] ]" & vbcrlf & _
				"    [ HAVING condition [, ...] ]" & vbcrlf & _
				"    [ { UNION | INTERSECT | EXCEPT [ ALL ] } select ]" & vbcrlf & _
				"    [ ORDER BY expression [ ASC | DESC | USING operator ] [, ...] ]" & vbcrlf & _
				"    [ FOR UPDATE [ OF tablename [, ...] ] ]" & vbcrlf & _
				"    [ LIMIT { count | ALL } [ { OFFSET | , } start ]]" & vbcrlf & _
				"" & vbcrlf & _
				"where from_item can be:" & vbcrlf & _
				"" & vbcrlf & _
				"[ ONLY ] table_name [ * ]" & vbcrlf & _
				"    [ [ AS ] alias [ ( column_alias_list ) ] ]" & vbcrlf & _
				"|" & vbcrlf & _
				"( select )" & vbcrlf & _
				"    [ AS ] alias [ ( column_alias_list ) ]" & vbcrlf & _
				"|" & vbcrlf & _
				"from_item [ NATURAL ] join_type from_item" & vbcrlf & _
				"    [ ON join_condition | USING ( join_column_list ) ]" )

		HelpCommad.Add "SET", _
			Array("Set run-time parameters", _
				"SET variable { TO | = } { value | 'value' | DEFAULT }" & vbcrlf & _
				"SET TIME ZONE { 'timezone' | LOCAL | DEFAULT }" )

		HelpCommad.Add "SET CONSTRAINTS", _
			Array("Set the constraint mode of the current SQL-transaction", _
				"SET CONSTRAINTS { ALL | constraint [, ...] } { DEFERRED | IMMEDIATE }" )

		HelpCommad.Add "SET TRANSACTION", _
			Array("Set the characteristics of the current SQL-transaction", _
				"SET TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }" & vbcrlf & _
				"SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }" )

		HelpCommad.Add "SHOW", _
			Array("Shows run-time parameters", _
				"SHOW name" )

		HelpCommad.Add "TRUNCATE", _
			Array("Empty a table", _
				"TRUNCATE [ TABLE ] name" )

		HelpCommad.Add "UNLISTEN", _
			Array("Stop listening for notification", _
				"UNLISTEN { notifyname | * }" )

		HelpCommad.Add "UPDATE", _
			Array("Replaces values of columns in a table", _
				"UPDATE [ ONLY ] table SET col = expression [, ...]" & vbcrlf & _
				"    [ FROM fromlist ]" & vbcrlf & _
				"    [ WHERE condition ]" )

		HelpCommad.Add "VACUUM", _
			Array("Clean and analyze a <productname>Postgres</productname> database", _
				"VACUUM [ VERBOSE ] [ ANALYZE ] [ table ]" & vbcrlf & _
				"VACUUM [ VERBOSE ] ANALYZE [ table [ (column [, ...] ) ] ]" )

		Set ReturnHelp = HelpCommad
	End Function
End Class
