/*
	defs.h

	Common definitions for oroject pgjobs.

	Project: pgjobs
	Author: Zlatko Michailov
	Created:  1-Oct-2003
	Updated:  2-Oct-2003
	Updated:  6-Oct-2003
	Updated: 14-Oct-2003
	Updated: 16-Oct-2003
	Updated: 28-Oct-2003

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) Zlatko Michailov, 2003

*/



#ifndef __DEFS_H__
#define __DEFS_H__



//--------------------------------------------------------------------------------
// Constants

// Config
const char	ConfigFilePath[]	= "/usr/share/pgjobs/pgjobs.conf";
const int	MaxLineLen			= 1024;
const char	BackupExt[]			= ".bak";
const char	RowMainChar			= '=';
const char	RowColChar			= '|';
const char	RowCommentChar		= '#';
const char	Default[]			= "default";
const char	None[]				= "none";
const char	Master[]			= "master";
const char	System[]			= "system";
const char	Postgres[]			= "postgres";



// Log
const char	LogRoot[]			= "/var/log/pgjobs/";
const char	LogExt[]			= ".txt";
const char	DatePattern[]		= "%4.4u.%2.2u.%2.2u";
const char	TimePattern[]		= "%2.2u:%2.2u:%2.2u";
const int	TMYearBase			= 1900;
const int	TMMonthBase			= 1;



// Status
const char	StatusStartup[]		= "Startup ";
const char	StatusRunning[]		= "Running ";
const char	StatusShutdown[]	= "Shutdown";



// Log Level
const char	LogLevelDefault[]	= "1";

enum LogLevel
{
	LogLevelError			= 0,
	LogLevelSystemInfo		= 1,
	LogLevelSystemVerbose	= 2,

	//LogLevelUndefined3	= 3,
	//LogLevelUndefined4	= 4,

	LogLevelDebug			= 5
};



// Message Command
enum MessageCommand
{
	CmdUnknown,

	// Log
	CmdLogInitAgent,
	CmdLogMessage
};



// Config manipulation
static const char	Indent[]		= "    ";

static const char*	SchemaSystem[]	=
{
	"Version"
};

static const char*	SchemaMaster[]	=
{
	"LogLevel"
};

static const char*	SchemaDb[]		=
{
	"Host        ",
	"Port        ",
	"Database    ",
	"LogLevel    ",
	"User        ",
	"Notification",
	"Recipient   "
};

const int SizeOfSchemaSystem	= sizeof( SchemaSystem ) / sizeof( char* );
const int SizeOfSchemaMaster	= sizeof( SchemaMaster ) / sizeof( char* );
const int SizeOfSchemaDb		= sizeof( SchemaDb ) / sizeof( char* );



//--------------------------------------------------------------------------------
// Utility functions

int mkdirhier( const char* path, int mode );
int setename( const char* name );



//--------------------------------------------------------------------------------



#endif	// __DEFS_H__


