/*
 * UserList.java
 *
 * Created on 31 de julio de 2002, 10:59
 */

package components.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class UserList extends TreeInfo {
    
    /** Creates a new instance of UserList */
    public UserList(RootElement source) {
        super(source);
        setIcon("/images/user.png");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs = getConnection().getQueryGenerator().getUserNames();
            while(rs.next()){
                addProperty(new Element(this, new User(getDatabase(), rs.getString("user_name"))));
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
        }
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Users";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
