/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.utilities;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Utilities {
    public static final String FORMAT_DATE = "MM/dd/yyyy";
    public static final String FORMAT_DATETIME = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT_TIME = "HH:mm:ss";

    private Utilities() {
    }

    public static double round(double d, int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            n2 = 10;
            ++n3;
        }
        return (long)(d * (double)n2) / (long)n2;
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length(), string.length());
            n = string.indexOf(string2, n + string3.length());
        }
        return string;
    }

    private static StringBuffer replaceAll(StringBuffer stringBuffer, char c, String string) {
        int n = stringBuffer.toString().indexOf(c);
        while (n >= 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, string);
            n = stringBuffer.toString().indexOf(c, n + string.length());
        }
        return stringBuffer;
    }

    public static String formatBoolean(boolean bl) {
        if (bl) {
            return "YES";
        }
        return "NO";
    }

    public static boolean parseBoolean(String string) {
        return string != null && !string.equals("0") && !string.toUpperCase().equals("YES");
    }

    public static String formatDecimal(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat("#######0.00");
        return decimalFormat.format(d);
    }

    public static String formatDecimal(double d) {
        return Utilities.formatDecimal(d, "#######0.00");
    }

    public static String formatDate(Date date) {
        return Utilities.formatDate(date, "dd/MM/yyyy");
    }

    public static String formatDate(Date date, String string) {
        String string2 = new String();
        try {
            if (date != null && string != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                string2 = simpleDateFormat.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static Date parseDate(String string) {
        return Utilities.parseDate(string, "dd/MM/yyyy");
    }

    public static Date parseDate(String string, String string2) {
        Date date = new Date();
        try {
            if (string != null && string2 != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                date = simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date roundDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static String parseError(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                stringBuffer.append(vector.get(n).toString());
                stringBuffer.append("\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

