/*
 * Decompiled with CFR 0.152.
 */
package components.group;

import components.group.UsersPanel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pgclibrary.objects.Group;
import pgclibrary.utilities.SUtilities;

public class GroupPanel
extends JTabbedPane {
    Group group_object = null;
    JTextField name = new JTextField(20);
    UsersPanel user_panel = new UsersPanel();
    JTextArea sql = new JTextArea();

    public GroupPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setGroup(Group group) {
        this.group_object = group;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
        this.addTab("Users", this.user_panel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GroupPanel.this.refreshProperties();
            }
        });
    }

    public void refreshProperties() {
        switch (this.getSelectedIndex()) {
            case 0: {
                this.refreshDefaultPanel();
                break;
            }
            case 1: {
                this.user_panel.refresh(this.group_object);
            }
        }
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.sql.setEditable(false);
        jSplitPane.setBottomComponent(new JScrollPane(this.sql));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(SUtilities.getHorPanel("Group Name :", this.name));
        jSplitPane.setTopComponent(SUtilities.centerComponent(jPanel));
        this.addTab("General", jSplitPane);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.group_object.getName());
        this.sql.setText(this.group_object.getInsertSQL());
        this.repaint();
    }
}

