/*
 * DatabaseQuerys.java
 *
 * Created on 14 de agosto de 2002, 11:37
 */

package pgclibrary.dataaccess;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public abstract class DatabaseQuerys {
    private static DatabaseQuerys defaultQG = null;
    
    /** Creates a new instance of DatabaseQuerys */
    protected DatabaseQuerys() {
    }
    
    /** Gets the Groups information
     */
    public abstract ResultSet getGroups(String _groupName);
    
    /** Get a table columninformation
     */
    public abstract ResultSet getTableColumn(String _tableName, String _columnName);
    
    /** Get a column description 
     */
    public abstract String getColumnDescription(String _tableName, String _columnName);

    /** Get an attribute type description
     */
    public abstract ResultSet getAttributeType(String _name);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getDatabases(String _name);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getUser(String _name);
    public abstract ResultSet getUser(long _sysID);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getIndex(String _name);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getColumnNames(String _tableName);
    
    /** Get an attribute type description
     */
    public abstract String getTableDescription(String _tableName);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getView(String _viewName);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getSequence(String _sequenceName);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getTable(String _tableName);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getIndexNames(String _tableName);
    
    /** Get an attribute type description
     */
    public abstract ResultSet getViewNames();
    
    /** Get an attribute type description
     */
    public abstract ResultSet getSequenceNames();
    
    /** Get an attribute type description
     */
    public abstract ResultSet getUserNames();
    
    /** Get an attribute type description
     */
    public abstract ResultSet getGroupNames();
    
    /** Get an attribute type description
     */
    public abstract ResultSet getDatabaseNames();
    
    /** Get an attribute type description
     */
    public abstract ResultSet getTableNames();
    
    
    /** Retrieve the appropiate DatabaseQuerys for the MainConnection
     */ 
    public static DatabaseQuerys getDefaultQueryGenerator(MainConnection _connection){
        if (_connection != null){
            if(_connection.getDatabaseVersion() >= 7.2){
                defaultQG = new DatabaseQuerys_7_2(_connection);
            } else {
                defaultQG = new DatabaseQuerys_7_1(_connection);
            }
        } else {
            defaultQG = null;
        }
        return defaultQG;
    }
}
