/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class View
extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    private String description = null;

    public View(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public View(DBObject owner) {
        super(owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP VIEW ");
        retorno.append(this.getName());
        retorno.append(";\n ");
        return retorno.toString();
    }

    public String getInsertSQL() {
        return this.getDefinition();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            ResultSet rs = this.getConnection().getQueryGenerator().getView(_name);
            if (rs != null && rs.next()) {
                this.setName(rs.getString("VIEW_NAME"));
                this.setCreator(new User((DBObject)this, rs.getString("VIEW_OWNER")));
                this.setDefinition(rs.getString("VIEW_DEFINITION"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.definition = new String();
        this.columns = null;
        this.description = null;
    }

    public dataSource getColumnsTable() {
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        Vector temp = this.getColumns();
        int i = 0;
        while (i < temp.size()) {
            TableColumn tc = (TableColumn)temp.get(i);
            Vector<String> elem = new Vector<String>();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            dsve.addElement(elem);
            ++i;
        }
        return dsve;
    }

    private void setDefinition(String _definition) {
        this.definition = _definition != null ? _definition : new String();
    }

    private String getDefinition() {
        StringBuffer retorno = new StringBuffer();
        retorno.append(this.definition);
        retorno.append(";\n");
        retorno.append(this.getCommentSQL());
        int i = 0;
        while (i > this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.getColumns().get(i);
            retorno.append(tc.getCommentSQL());
            ++i;
        }
        return this.definition;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet rs = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (rs != null && rs.next()) {
                    this.columns.add(new TableColumn(this, rs.getString("COLUMN_NAME")));
                }
                rs.close();
                rs.getStatement().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.columns;
    }

    private String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON VIEW " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getName());
    }
}

