/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.AttributeType;
import pgclibrary.objects.DBObject;

public class TableColumn
extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = new String();
    private String description = null;

    public TableColumn(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public String getDeleteSQL() {
        return new String();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append(this.getName());
        retorno.append(" ");
        if (this.getColumnType() != null) {
            retorno.append(this.getColumnType().getName().toUpperCase());
            retorno.append(" ");
            if (this.getColumnType().getSize() < 0) {
                retorno.append("(");
                retorno.append(this.getSize());
                retorno.append(") ");
            }
        }
        if (!this.allowNulls()) {
            retorno.append("NOT NULL ");
        }
        if (this.getDefaultValue() != null && this.getDefaultValue().trim().length() > 0) {
            retorno.append("DEFAULT ");
            retorno.append(this.getDefaultValue());
        }
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            ResultSet rs = this.getConnection().getQueryGenerator().getTableColumn(this.getOwner().getName(), _name);
            if (rs != null && rs.next()) {
                this.setName(rs.getString("COLUMN_NAME"));
                this.setColumnNumber(rs.getInt("COLUMN_NUMBER"));
                this.setSize(rs.getInt("COLUMN_SIZE"));
                this.setAllowNulls(!rs.getBoolean("COLUMN_NOTNULL"));
                this.setColumnType(AttributeType.searchObject(rs.getString("TYPE_NAME")));
                this.setDefaultValue(rs.getString("DEFAULT_VALUE"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.col_number = 0;
        this.size = 0;
        this.allow_nulls = false;
        this.column_type = null;
        this.default_value = new String();
        this.description = null;
    }

    private void setDefaultValue(String _value) {
        this.default_value = _value != null ? _value : new String();
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    private void setColumnNumber(int _col_number) {
        this.col_number = _col_number;
    }

    public int getColumnNumber() {
        return this.col_number;
    }

    private void setSize(int _size) {
        this.size = _size;
    }

    public int getSize() {
        if (this.size > 0) {
            return this.size;
        }
        return this.column_type.getSize();
    }

    private void setAllowNulls(boolean _allow_nulls) {
        this.allow_nulls = _allow_nulls;
    }

    public boolean allowNulls() {
        return this.allow_nulls;
    }

    public AttributeType getColumnType() {
        return this.column_type;
    }

    private void setColumnType(AttributeType _column_type) {
        this.column_type = _column_type;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getColumnDescription(this.getOwner().getName(), this.getName());
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    protected String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON COLUMN " + this.getOwner().getName() + "." + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    public void refresh() {
        this.search(this.getName());
    }
}

