/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import pgclibrary.treeObjects.RootElement;
import pgclibrary.treeObjects.TreeInfo;

public class TreeControlModel
implements TreeModel {
    private RootElement rootDatabase;
    private Vector treeModelListeners = new Vector();

    public TreeControlModel(RootElement rootData) {
        this.rootDatabase = rootData;
    }

    public void setNewRoot(RootElement rootData) {
        this.rootDatabase = rootData;
        this.fireTreeStructureChanged();
    }

    public void fireTreeStructureChanged() {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.rootDatabase});
        int i = 0;
        while (i < len) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
            ++i;
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    public Object getChild(Object parent, int index) {
        TreeInfo temp = (TreeInfo)parent;
        Object retorno = null;
        if (index >= 0 && index < temp.getSize()) {
            retorno = temp.getProperties().get(index);
        }
        return retorno;
    }

    public int getChildCount(Object parent) {
        TreeInfo temp = (TreeInfo)parent;
        return temp.getSize();
    }

    public int getIndexOfChild(Object parent, Object child) {
        TreeInfo temp = (TreeInfo)parent;
        return temp.getPropertyIndex((TreeInfo)child);
    }

    public Object getRoot() {
        return this.rootDatabase;
    }

    public boolean isLeaf(Object node) {
        TreeInfo temp = (TreeInfo)node;
        if (!temp.isInitialized()) {
            return false;
        }
        return temp.getSize() == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

