/*
 * SQLTextParser.java
 *
 * Created on 19 de julio de 2002, 19:12
 */

package pgclibrary.utilities;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

/**
 *
 * @author  nestor
 */
public class SQLTextParser {
    private JTextPane text = null;
    private int last_offset_read = 0;
    
    /** These are the init offset and the end offset of the control
     *    used for optimization only
     */
    private int _start_off = 0;
    private int _end_off = 0;
    
    /** Creates a new instance of SQLTextParser */
    public SQLTextParser(JTextPane _text) {
        text = _text;
    }
    
    public String getCommand(int _offset){
        return getParagraph(_offset);
    }
    
    public String getNextCommand(){
        String retorno = new String();
        while ((retorno.length() == 0)
            && (last_offset_read < _end_off)){
            
            retorno = getParagraph(last_offset_read + 2);
        }
        return retorno;
    }
    
    public String getFirstCommand(){
        return getParagraph(0);
    }
    
    // -----INTERNAL METHODS-------
    private String getParagraph(int _offset){
        _start_off = text.getDocument().getStartPosition().getOffset();
        _end_off = text.getDocument().getEndPosition().getOffset() -1;
        
        String retorno = new String();
        if ((_offset < (_end_off +1))  && (_offset >= _start_off)){
            int start = getParagraphStartOffset(_offset);
            last_offset_read = getParagraphEndOffset(_offset);
            
            try{
                retorno = text.getDocument().getText(start, last_offset_read - start);
            } catch (Exception e){
                retorno = new String();
            }
            retorno = Utilities.replaceAll(retorno, "\n", " ");
            retorno = Utilities.replaceAll(retorno, "\t", " ");
            retorno = retorno.trim();
            if ((retorno.length() > 0) && (retorno.charAt(retorno.length()-1) == ';')){
                retorno = retorno.substring(0, retorno.length() - 1);
            }
            if ((retorno.length() > 0) && (retorno.charAt(0) == ';')){
                retorno = retorno.substring(1, retorno.length());
            }
            retorno = retorno.trim();
        }
        return retorno;
    }
    
    private int getParagraphStartOffset(int _offset){
        int retorno = _offset;
        
        if(retorno <= _start_off){
            retorno = _start_off + 1;
        }
        
        boolean found = false;
        while ((!found) && ((--retorno) > _start_off)) {
            try {
                if(text.getDocument().getText(retorno, 1).equals("\n")){
                    String last = getPrevChar(retorno);
                    found = (last == null) || (last.equals("\n")) || last.equals(";");
                }
            } catch (Exception e){
                found = true;
            }
        }
        return retorno;
    }
    private int getParagraphEndOffset(int _offset){
        int retorno = _offset - 1;
        
        boolean found = false;
        while (!found &&  ((++retorno) <= _end_off)) {
            try{
                if(text.getDocument().getText(retorno, 1).equals("\n")){
                    String last = getPrevChar(retorno);
                    found = (last == null) || (last.equals("\n")) || last.equals(";");
                }
            } catch (Exception e){
                found = true;
            }
        }
        return retorno;
    }
    
    private String getPrevChar(int offset){
        String retorno = null;
        try{
            offset--;
            while ((offset >= _start_off)
                    && text.getDocument().getText(offset, 1).equals(" ")){
                offset --;
            }
            
            if(offset >= _start_off){
                retorno = text.getDocument().getText(offset, 1);
            }
        } catch (Exception e){}
        return retorno;
    }
}
