/*
 * pageProperties.java
 *
 * Created on 9 de agosto de 2001, 11:53
 */

package pgclibrary.utilities;

import java.util.*;
import java.io.*;

/** Almacena propiedades de p\u00e1gina. Es una colecci\u00f3n propiedades / Valores para
 * paginas. Es mucho mas comodo que utilizar la sesion y mucho mas ordenado.
 *
 * @author Nestor Marsollier
 * @version 1.0
 */

public class SystemProps extends Object {
    private int pageNro = 1;
    private Hashtable props = null;
    
    /** Creates new pageProperties */
    public SystemProps() {
        readProperties();
    }
    
    public void readProperties(){
        try{
            FileReader read_options = new FileReader("./properties");
            BufferedReader input = new BufferedReader(read_options);
            
            try{
                String tmp = input.readLine();
                
                while(tmp != null){
                    String useful_line = new String(tmp);
                    if(tmp.indexOf("#") > 0){
                        useful_line = tmp.substring(0, tmp.indexOf("#"));
                    }
                    if(useful_line.indexOf("=") > 0){
                        String param = useful_line.substring(0, useful_line.indexOf("="));
                        String value = useful_line.substring(useful_line.indexOf("=") + 1, useful_line.length());
                        if ((param.length() > 0)  && (value.length() > 0)){
                            setProperty(param, value);
                        }
                    }
                    tmp = input.readLine();
                }
            } catch (Exception ex){
                ex.printStackTrace();
            }
            
            input.close();
            read_options.close();
        } catch (Exception e){
            e.printStackTrace();
        }
    }
    
    /** Creates new pageProperties */
    public void writeProperties() {
        try{
            FileWriter write_options = new FileWriter("./properties", false);
            BufferedWriter output = new BufferedWriter(write_options);
            
            try{
                Enumeration i = props.keys();
                while(i.hasMoreElements()){
                    String key = (String) i.nextElement();
                    output.write(key);
                    output.write("=");
                    output.write(getProperty(key));
                    output.write("\n");
                }
            } catch (Exception ex){
                ex.printStackTrace();
            }
            
            output.close();
            write_options.close();
        } catch (Exception e){
            e.printStackTrace();
        }
    }
    
    private void validateProps(){
        if (props == null){
            props = new Hashtable(5);
        }
    }
    
    /** Establece una propiedad / valor en el objeto.
     * @param _name Nombre de la propiedad.
     * @param _value Valor a almacenar.
     */
    public void setProperty(String _name, String _value){
        validateProps();
        if (props.get(_name) == null ){
            props.put(_name, _value);
        } else {
            props.remove(_name);
            props.put(_name, _value);
        }
    }
    
    /** Devuelve un String con el valor almacenado para la propiedad que se consulta.
     * En el caso que la propiedad no exista se devuelve un "new String()"
     * @param _name Nombre de la propiedad.
     * @return Valor de la propiedad.
     * New String() si la propiedad no existe.
     */
    public String getProperty(String _name){
        validateProps();
        if (props.get(_name) == null ){
            props.put(_name, new String());
        }
        return (String) props.get(_name);
    }
}
