/*
 * SQLExecutionMenu.java
 *
 * Created on 18 de julio de 2002, 16:38
 */

package frames;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  nestor
 */
public class SQLExecutionMenu extends JMenuBar{
    SQLExecutionFrame frame = null;
    JMenuItem execute = null;
    JMenuItem execute_all = null;
    JMenuItem log_act = null;
    JMenuItem log_canc = null;
    JMenuItem undo = null;
    JMenuItem redo = null;
    
    /** Creates a new instance of SQLExecutionMenu */
    public SQLExecutionMenu(SQLExecutionFrame _frame) {
        frame = _frame;
        
// FILE
        JMenu file = new JMenu("File");
        file.setMnemonic(KeyEvent.VK_F);
        add(file);
        
        JMenuItem open = new JMenuItem("Open File...");
        open.setMnemonic(KeyEvent.VK_O);
        open.setActionCommand(SQLExecutionListener.AC_OPEN_FILE);
        open.addActionListener(frame.getListener());
        file.add(open);
        JMenuItem save = new JMenuItem("Save As...");
        save.setMnemonic(KeyEvent.VK_S);
        save.setActionCommand(SQLExecutionListener.AC_SAVE_FILE);
        save.addActionListener(frame.getListener());
        file.add(save);
        
        file.addSeparator();
        
        JMenuItem exit = new JMenuItem("Close Window");
        exit.setMnemonic(KeyEvent.VK_C);
        exit.setActionCommand(SQLExecutionListener.AC_CLOSE);
        exit.addActionListener(frame.getListener());
        file.add(exit);
        
// EDIT
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic(KeyEvent.VK_E);
        add(edit);
        
        JMenuItem undo = new JMenuItem("Undo");
        undo.setMnemonic(KeyEvent.VK_U);
        undo.setActionCommand(SQLExecutionListener.AC_UNDO);
        undo.addActionListener(frame.getListener());
        edit.add(undo);
        JMenuItem redo = new JMenuItem("Redo");
        redo.setMnemonic(KeyEvent.VK_R);
        redo.setActionCommand(SQLExecutionListener.AC_REDO);
        redo.addActionListener(frame.getListener());
        edit.add(redo);
        
// TOOLS
        JMenu tools = new JMenu("Tools");
        tools.setMnemonic(KeyEvent.VK_T);
        add(tools);

        log_act = new JMenuItem("Log querys...");
        log_act.setActionCommand(SQLExecutionListener.AC_LOG_QUERYS);
        log_act.addActionListener(frame.getListener());
        tools.addSeparator();
        tools.add(log_act);
        log_canc = new JMenuItem("Stop Logs");
        log_canc.setActionCommand(SQLExecutionListener.AC_CANCEL_LOG);
        log_canc.addActionListener(frame.getListener());
        tools.add(log_canc);
        
        execute = new JMenuItem("Execute command");
        execute.setMnemonic(KeyEvent.VK_E);
        execute.setActionCommand(SQLExecutionListener.AC_EXECUTE);
        execute.addActionListener(frame.getListener());
        tools.addSeparator();
        tools.add(execute);
        execute_all = new JMenuItem("Execute All");
        execute_all.setMnemonic(KeyEvent.VK_A);
        execute_all.setActionCommand(SQLExecutionListener.AC_EXECUTE_ALL);
        execute_all.addActionListener(frame.getListener());
        tools.add(execute_all);
        add(Box.createHorizontalGlue());
    }
    
    public void  refreshValidation(){
        if(frame != null){
            boolean valid = frame.getPrincipalFrame().getDatabase().validate();
            execute.setEnabled(valid);
            execute_all.setEnabled(valid);
            log_act.setEnabled(valid && !frame.isLogActive());
            log_canc.setEnabled(valid && frame.isLogActive());
        }
    }    
}

