/*
 * PrincipalFrameToolbar.java
 *
 * Created on 18 de julio de 2002, 15:40
 */

package frames;
import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author  nestor
 */
public class PrincipalFrameToolbar extends JToolBar{
    private PrincipalFrame frame = null;
    private JButton refresh = null;
    private JButton sql = null;
    
    /** Creates a new instance of PrincipalFrameToolbar */
    public PrincipalFrameToolbar(PrincipalFrame _frame){
        frame = _frame;
        
        JButton connect = new JButton(new ImageIcon("images/connect.png"));
        connect.setActionCommand(PrincipalFrameListener.AC_CONNECT);
        connect.setToolTipText("Connect to the database");
        connect.addActionListener(frame.getListener());
        this.add(connect);
        
        refresh = new JButton(new ImageIcon("images/reload.png"));
        refresh.setActionCommand(PrincipalFrameListener.AC_REFRESH);
        refresh.setToolTipText("Refresh data");
        refresh.addActionListener(frame.getListener());
        this.add(refresh);

        this.addSeparator();
        sql = new JButton(new ImageIcon("images/sql.png"));
        sql.setActionCommand(PrincipalFrameListener.AC_SQL_WINDOW);
        sql.setToolTipText("New SQL Window");
        sql.addActionListener(frame.getListener());
        this.add(sql);
        
        this.addSeparator();
        JButton options = new JButton(new ImageIcon("images/options.png"));
        options.setActionCommand(PrincipalFrameListener.AC_OPTIONS);
        options.setToolTipText("System Options");
        options.addActionListener(frame.getListener());
        this.add(options);
        
        JButton exit = new JButton(new ImageIcon("images/exit.png"));
        exit.setActionCommand(PrincipalFrameListener.AC_EXIT);
        exit.setToolTipText("Exit");
        exit.addActionListener(frame.getListener());
        this.addSeparator();
        this.add(exit);
    }
    
    public void refreshValidation(){
        if(frame != null){
            boolean valid = frame.getDatabase().validate();
            sql.setEnabled(valid);
            refresh.setEnabled(valid);
        }
    }
}
