package components.table;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class TablePanel extends JTabbedPane {
    Table table_object = null;
    
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextField pages = new JTextField(20);
    JTextField description = new JTextField(20);
    
    DataPanel data_panel = new DataPanel();
    ColumnPanel column_panel = new ColumnPanel();
    IndexPanel index_panel = new IndexPanel();

    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public TablePanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setTable(Table _table_object){
        table_object = _table_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
        addTab("Columns", column_panel);
        addTab("Data", data_panel);
        addTab("Indexes", index_panel);
        addChangeListener(new ChangeListener(){
                public void stateChanged(ChangeEvent e){
                    refreshProperties();
                }
            }
        );
    }
    
    public void refreshProperties(){
        switch(this.getSelectedIndex()){
            case 0:
                refreshDefaultPanel();
                break;
            case 1:
                column_panel.refresh(table_object);
                break;
            case 2:
                data_panel.refresh(table_object);
                break;
            case 3:
                index_panel.refresh(table_object);
                break;
        }
    }
        
    private void insertDefaultTab() {
        oid.setEditable(false);
        name.setEditable(false);
        owner.setEditable(false);
        pages.setEditable(false);
        description.setEditable(false);
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("Table ID :", oid));
        general_panel.add(SUtilities.getHorPanel("Table Name :", name));
        general_panel.add(SUtilities.getHorPanel("Description :", description));
        general_panel.add(SUtilities.getHorPanel("Table Owner :", owner));
        general_panel.add(SUtilities.getHorPanel("Disk Pages Used :", pages));
        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        oid.setText(String.valueOf(table_object.getOID()));
        name.setText(table_object.getName());
        owner.setText(table_object.getCreator().getName());
        pages.setText(String.valueOf(table_object.getNumberOfPages()));
        sql.setText(table_object.getInsertSQL());
        description.setText(table_object.getDescription());
        repaint();
    }
}


