/*
 * DataPanel.java
 *
 * Created on 31 de julio de 2002, 16:53
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class DataPanel extends JPanel{
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private DataPanelListener listener = null;
    private Hashtable tales_order = new Hashtable(100);
    
    /** Creates a new instance of DataPanel */
    public DataPanel() {
        data_table = new SQLTable();
        listener = new DataPanelListener(this);
        initPanel();
    }
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        add(new DataPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(new dataSourceResultSet(table.getConnection(), generateSQL()));
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    private String generateSQL(){
        StringBuffer retorno = new StringBuffer();
        if(table != null){
            retorno.append("SELECT * FROM ").append(table.getName());
            Vector order = getOrder();
            if(order.size() > 0){
                retorno.append(" ORDER BY ");
                for(int i= 0; i<order.size(); i++){
                    retorno.append(order.get(i));
                    if(i < (order.size() - 1)){
                        retorno.append(", ");
                    } else {
                        retorno.append(" ");
                    }
                }
            }
        }
        return retorno.toString();
    }
    
    public void addOrder(String _column){
        if ((_column != null) && (getOrderPos(_column) < 0)){
            getOrder().add(_column);
        }
    }
    public void clearOrder(){
        getOrder().removeAllElements();
    }
    public int getOrderPos(String _column){
        int retorno = -1;
        Vector order = getOrder();
        for(int i=0 ; (i<order.size()) && (retorno < 0); i++){
            if (((String) order.get(i)).equals(_column)){
                retorno = i;
            }
        }
        return retorno;
    }
    
    public Vector getOrder(){
        Vector retorno = (Vector) tales_order.get(table.getName());
        if(retorno == null){
            retorno = new Vector();
            tales_order.put(table.getName(), retorno);
        }
        return retorno;
    }
    
    public Table getTable(){
        return table;
    }
    
    public DataPanelListener getListener(){
        return listener;
    }
    
    public void showOrderDialog(){
        (new DataPanelOrderDialog(this)).show();
    }
    public void newRecord(){
    }
    public void editRecord(){
    }
    public void deleteRecord(){
    }
}
