/*
 * GroupPanelToolbar.java
 *
 * Created on 1 de agosto de 2002, 16:35
 */

package components.group;
import components.*;
import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author  nestor
 */
public class UsersPanelToolbar extends JToolBar {
    UsersPanel panel = null;
    JButton sort = null;
    JButton newRecord = null;
    JButton deleteRecord = null;
    
    /** Creates a new instance of GroupPanelToolbar */
    public UsersPanelToolbar(UsersPanel _panel) {
        panel = _panel;
        
        newRecord = new JButton(new ImageIcon("images/new.png"));
        newRecord.setActionCommand(UsersPanelListener.AC_NEW);
        newRecord.setToolTipText("Add User");
        newRecord.addActionListener(panel.getListener());
        this.add(newRecord);
        deleteRecord = new JButton(new ImageIcon("images/delete.png"));
        deleteRecord.setActionCommand(UsersPanelListener.AC_DELETE);
        deleteRecord.setToolTipText("Remove User");
        deleteRecord.addActionListener(panel.getListener());
        this.add(deleteRecord);
        
        this.add(Box.createHorizontalGlue());
    }
    
    public void refreshValidation(){
        if(panel.getGroup() != null){
            boolean valid = panel.getGroup() != null;
            sort.setEnabled(valid);
            newRecord.setEnabled(valid);
            deleteRecord.setEnabled(valid);
        }
    }
}
