/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/util/struct/SlaveInitializer.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:31 $
 *
 */

package com.postgres.replic.util.struct;

import java.sql.*;

public class SlaveInitializer implements DataConst {

    public SlaveInitializer(Connection conn, int serverId) throws Exception {
        if (conn == null) {
            throw new Exception("SlaveInitializer: connection may not be null");
        }
        if (serverId < 0) {
            throw new Exception("SlaveInitializer: serverId may not be negative");
        }
        this.conn = conn;
        this.serverId = serverId;
    }

    private Connection conn;
    private int serverId = T_NO;

    public Connection getConnection(){
        return conn;
    }

    public int getServerId(){
        return serverId;
    }
}
