/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private String vmVersion;

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.sysProperties.addVariable(sysp);
    }

    public void setVm(String vm) {
        this.vmCommand.setExecutable(vm);
    }

    public void setVmversion(String value) {
        this.vmVersion = value;
    }

    public void setClassname(String classname) {
        this.javaCommand.setExecutable(classname);
    }

    public String getClassname() {
        return this.javaCommand.getExecutable();
    }

    public Path createClasspath(Project p) {
        if (this.classpath == null) {
            this.classpath = new Path(p);
        }
        return this.classpath;
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public String[] getCommandline() {
        int size = this.vmCommand.size() + this.javaCommand.size() + this.sysProperties.size();
        if (this.classpath != null && this.classpath.size() > 0) {
            size += 2;
        }
        String[] result = new String[size];
        System.arraycopy(this.vmCommand.getCommandline(), 0, result, 0, this.vmCommand.size());
        int pos = this.vmCommand.size();
        if (this.sysProperties.size() > 0) {
            System.arraycopy(this.sysProperties.getVariables(), 0, result, pos, this.sysProperties.size());
            pos += this.sysProperties.size();
        }
        if (this.classpath != null && this.classpath.size() > 0) {
            result[pos++] = "-classpath";
            result[pos++] = this.classpath.toString();
        }
        System.arraycopy(this.javaCommand.getCommandline(), 0, result, pos, this.javaCommand.size());
        return result;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public int size() {
        int size = this.vmCommand.size() + this.javaCommand.size();
        if (this.classpath != null && this.classpath.size() > 0) {
            size += 2;
        }
        return size;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    public Commandline getVmCommand() {
        return this.vmCommand;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Object clone() {
        CommandlineJava c = new CommandlineJava();
        c.vmCommand = (Commandline)this.vmCommand.clone();
        c.javaCommand = (Commandline)this.javaCommand.clone();
        c.sysProperties = (SysProperties)this.sysProperties.clone();
        c.classpath = (Path)this.classpath.clone();
        c.vmVersion = this.vmVersion;
        return c;
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    public CommandlineJava() {
        this.setVm("java");
        this.setVmversion(Project.getJavaVersion());
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;

        public String[] getVariables() throws BuildException {
            String[] props = super.getVariables();
            if (props == null) {
                return null;
            }
            int i = 0;
            while (i < props.length) {
                props[i] = "-D" + props[i];
                ++i;
            }
            return props;
        }

        public int size() {
            return this.variables.size();
        }

        public void setSystem() throws BuildException {
            try {
                this.sys = System.getProperties();
                Properties p = new Properties(this.sys);
                Enumeration e = this.variables.elements();
                while (e.hasMoreElements()) {
                    Environment.Variable v = (Environment.Variable)e.nextElement();
                    ((Hashtable)p).put(v.getKey(), v.getValue());
                }
                System.setProperties(p);
            }
            catch (SecurityException e) {
                throw new BuildException("Cannot modify system properties", e);
            }
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException e) {
                throw new BuildException("Cannot modify system properties", e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Object clone() {
            try {
                void e;
                SysProperties c = (SysProperties)super.clone();
                c.variables = (Vector)this.variables.clone();
                return e;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

