/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Delete
extends MatchingTask {
    protected File file = null;
    protected File dir = null;
    protected Vector filesets = new Vector();
    protected boolean usedMatchingTask = false;
    private int verbosity = 3;
    private boolean quiet = false;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.usedMatchingTask = true;
        super.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.usedMatchingTask = true;
        super.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(useDefaultExcludes);
    }

    public void setIncludesfile(File includesfile) {
        this.usedMatchingTask = true;
        super.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.usedMatchingTask = true;
        super.setExcludesfile(excludesfile);
    }

    public void execute() throws BuildException {
        if (this.usedMatchingTask) {
            this.log("DEPRECATED - Use of the implicit FileSet is deprecated.  Use a nested fileset element instead.");
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " cannot be removed using the file attribute.  Use dir instead.");
                } else {
                    this.log("Deleting: " + this.file.getAbsolutePath());
                    if (!this.quiet && !this.file.delete()) {
                        throw new BuildException("Unable to delete file " + this.file.getAbsolutePath());
                    }
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to delete.");
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            this.log("Deleting directory " + this.dir.getAbsolutePath());
            this.removeDir(this.dir);
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] files = ds.getIncludedFiles();
            this.removeFiles(fs.getDir(this.project), files);
            ++i;
        }
        if (this.usedMatchingTask && this.dir != null) {
            DirectoryScanner ds = super.getDirectoryScanner(this.dir);
            String[] files = ds.getIncludedFiles();
            this.removeFiles(this.dir, files);
        }
    }

    protected void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                this.removeDir(f);
            } else {
                this.log("Deleting " + f.getAbsolutePath(), this.verbosity);
                if (!this.quiet && !f.delete()) {
                    throw new BuildException("Unable to delete file " + f.getAbsolutePath());
                }
            }
            ++i;
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!this.quiet && !d.delete()) {
            throw new BuildException("Unable to delete directory " + this.dir.getAbsolutePath());
        }
    }

    protected void removeFiles(File d, String[] files) {
        if (files.length > 0) {
            this.log("Deleting " + files.length + " files from " + d.getAbsolutePath());
            int j = 0;
            while (j < files.length) {
                File f = new File(d, files[j]);
                this.log("Deleting " + f.getAbsolutePath(), this.verbosity);
                if (!this.quiet && !f.delete()) {
                    throw new BuildException("Unable to delete file " + f.getAbsolutePath());
                }
                ++j;
            }
        }
    }
}

