/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;

public class IntrospectionHelper {
    private static Hashtable helpers = new Hashtable();
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private Method addText = null;
    private Class bean;
    private static /* synthetic */ Class class$Lorg$apache$tools$ant$Task;
    private static /* synthetic */ Class class$Lorg$apache$tools$ant$Location;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Class;
    private static /* synthetic */ Class class$Ljava$io$File;
    private static /* synthetic */ Class class$Lorg$apache$tools$ant$types$Path;
    private static /* synthetic */ Class class$Lorg$apache$tools$ant$types$EnumeratedAttribute;

    public static synchronized IntrospectionHelper getHelper(Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
        }
        return ih;
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName);
        if (as == null) {
            String msg = "Class " + element.getClass().getName() + " doesn't support the \"" + attributeName + "\" attribute";
            throw new BuildException(msg);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void addText(Object element, String text) {
        if (this.addText == null) {
            String msg = "Class " + element.getClass().getName() + " doesn't support nested text elements";
            throw new BuildException(msg);
        }
        try {
            this.addText.invoke(element, (Object[])new String[]{text});
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Object createElement(Object element, String elementName) throws BuildException {
        NestedCreator nc = (NestedCreator)this.nestedCreators.get(elementName);
        if (nc == null) {
            String msg = "Class " + element.getClass().getName() + " doesn't support the nested \"" + elementName + "\" element";
            throw new BuildException(msg);
        }
        try {
            return nc.create(element);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element";
            throw new BuildException(msg);
        }
        return nt;
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute";
            throw new BuildException(msg);
        }
        return at;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    private AttributeSetter createAttributeSetter(Method m, Class arg) {
        if ((class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = IntrospectionHelper.class$("java.lang.String"))).equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new String[]{value});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = IntrospectionHelper.class$("java.lang.Character"))).equals(arg) || Character.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Byte.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Byte[]{new Byte(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Short.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Short[]{new Short(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Integer.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Integer[]{new Integer(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Long.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Long[]{new Long(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Float.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Float[]{new Float(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if (Double.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Double[]{new Double(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean"))).equals(arg) || Boolean.TYPE.equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Boolean[]{new Boolean(Project.toBoolean(value))});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = IntrospectionHelper.class$("java.lang.Class"))).equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        this.val$m.invoke(parent, (Object[])new Class[]{Class.forName(value)});
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Ljava$io$File != null ? class$Ljava$io$File : (class$Ljava$io$File = IntrospectionHelper.class$("java.io.File"))).equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new File[]{p.resolveFile(value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Lorg$apache$tools$ant$types$Path != null ? class$Lorg$apache$tools$ant$types$Path : (class$Lorg$apache$tools$ant$types$Path = IntrospectionHelper.class$("org.apache.tools.ant.types.Path"))).equals(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    this.val$m.invoke(parent, (Object[])new Path[]{new Path(p, value)});
                }
                {
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        if ((class$Lorg$apache$tools$ant$types$EnumeratedAttribute != null ? class$Lorg$apache$tools$ant$types$EnumeratedAttribute : (class$Lorg$apache$tools$ant$types$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.types.EnumeratedAttribute"))).isAssignableFrom(arg)) {
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, arg, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Class val$arg;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)this.val$arg.newInstance();
                        ea.setValue(value);
                        this.val$m.invoke(parent, (Object[])new EnumeratedAttribute[]{ea});
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
                {
                    this.val$arg = val$arg;
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        try {
            Constructor c = arg.getConstructor(class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = IntrospectionHelper.class$("java.lang.String")));
            IntrospectionHelper introspectionHelper = this;
            if (introspectionHelper == null) {
                throw null;
            }
            return new AttributeSetter(introspectionHelper, c, m){
                private final /* synthetic */ IntrospectionHelper this$0;
                private final /* synthetic */ Constructor val$c;
                private final /* synthetic */ Method val$m;

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        this.val$m.invoke(parent, this.val$c.newInstance(value));
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
                {
                    this.val$c = val$c;
                    this.val$m = val$m;
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(IntrospectionHelper introspectionHelper) {
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private String getPropertyName(String methodName, String prefix) {
        int start = prefix.length();
        return methodName.substring(start).toLowerCase();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (!((class$Lorg$apache$tools$ant$Task != null ? class$Lorg$apache$tools$ant$Task : IntrospectionHelper.class$("org.apache.tools.ant.Task")).isAssignableFrom(bean) && args.length == 1 && ("setLocation".equals(name) && (class$Lorg$apache$tools$ant$Location != null ? class$Lorg$apache$tools$ant$Location : IntrospectionHelper.class$("org.apache.tools.ant.Location")).equals(args[0]) || "setTaskType".equals(name) && (class$Ljava$lang$String != null ? class$Ljava$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0])))) {
                String propName;
                if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$Ljava$lang$String != null ? class$Ljava$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0])) {
                    this.addText = methods[i];
                } else if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                    propName = this.getPropertyName(name, "set");
                    AttributeSetter as = this.createAttributeSetter(m, args[0]);
                    if (as != null) {
                        this.attributeTypes.put(propName, args[0]);
                        this.attributeSetters.put(propName, as);
                    }
                } else if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                    propName = this.getPropertyName(name, "create");
                    this.nestedTypes.put(propName, returnType);
                    IntrospectionHelper introspectionHelper = this;
                    if (introspectionHelper == null) {
                        throw null;
                    }
                    this.nestedCreators.put(propName, new NestedCreator(introspectionHelper, m){
                        private final /* synthetic */ IntrospectionHelper this$0;
                        private final /* synthetic */ Method val$m;

                        public Object create(Object parent) throws InvocationTargetException, IllegalAccessException {
                            return this.val$m.invoke(parent, new Object[0]);
                        }
                        {
                            this.val$m = val$m;
                            this.this$0 = this$0;
                            this.constructor$0(this$0);
                        }

                        private final void constructor$0(IntrospectionHelper introspectionHelper) {
                        }
                    });
                } else if (name.startsWith("add") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$Ljava$lang$String != null ? class$Ljava$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        Constructor<?> c = args[0].getConstructor(new Class[0]);
                        String propName2 = this.getPropertyName(name, "add");
                        this.nestedTypes.put(propName2, args[0]);
                        IntrospectionHelper introspectionHelper = this;
                        if (introspectionHelper == null) {
                            throw null;
                        }
                        this.nestedCreators.put(propName2, new NestedCreator(introspectionHelper, c, m){
                            private final /* synthetic */ IntrospectionHelper this$0;
                            private final /* synthetic */ Constructor val$c;
                            private final /* synthetic */ Method val$m;

                            public Object create(Object parent) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                T o = this.val$c.newInstance(new Object[0]);
                                this.val$m.invoke(parent, o);
                                return o;
                            }
                            {
                                this.val$c = val$c;
                                this.val$m = val$m;
                                this.this$0 = this$0;
                                this.constructor$0(this$0);
                            }

                            private final void constructor$0(IntrospectionHelper introspectionHelper) {
                            }
                        });
                    }
                    catch (NoSuchMethodException nse) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private static interface NestedCreator {
        public Object create(Object var1) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    private static interface AttributeSetter {
        public void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }
}

