/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class AntClassLoader
extends ClassLoader {
    private static final int BUFFER_SIZE = 1024;
    private Path classpath;
    private Project project;
    private boolean systemFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();

    public void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.addElement(packageRoot + ".");
    }

    public void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.addElement(packageRoot + ".");
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        this.project.log("force loading " + classname, 4);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    public Class forceLoadSystemClass(String classname) throws ClassNotFoundException {
        this.project.log("force system loading " + classname, 4);
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findSystemClass(classname);
        }
        return theClass;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = null;
        String[] pathElements = this.classpath.list();
        int i = 0;
        while (i < pathElements.length && stream == null) {
            File pathComponent = this.project.resolveFile(pathElements[i]);
            stream = this.getResourceStream(pathComponent, name);
            ++i;
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getResourceStream(File file, String resourceName) {
        try {
            ZipFile zipFile;
            block7: {
                ByteArrayInputStream byteArrayInputStream;
                if (!file.exists()) {
                    return null;
                }
                if (file.isDirectory()) {
                    File resource = new File(file, resourceName);
                    if (!resource.exists()) return null;
                    return new FileInputStream(resource);
                }
                zipFile = null;
                try {
                    int bytesRead;
                    zipFile = new ZipFile(file);
                    ZipEntry entry = zipFile.getEntry(resourceName);
                    if (entry == null) break block7;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    InputStream stream = zipFile.getInputStream(entry);
                    while ((bytesRead = stream.read(buffer, 0, 1024)) != -1) {
                        void var10_10;
                        baos.write(buffer, 0, (int)var10_10);
                    }
                    byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    Object var5_12 = null;
                    if (zipFile == null) return byteArrayInputStream;
                }
                catch (Throwable throwable) {
                    Object var5_14 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
                return byteArrayInputStream;
            }
            Object var5_13 = null;
            if (zipFile == null) return null;
            zipFile.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        String packageName;
        boolean useSystemFirst = this.systemFirst;
        Enumeration e = this.systemPackages.elements();
        while (e.hasMoreElements()) {
            packageName = (String)e.nextElement();
            if (!classname.startsWith(packageName)) continue;
            useSystemFirst = true;
            break;
        }
        e = this.loaderPackages.elements();
        while (e.hasMoreElements()) {
            packageName = (String)e.nextElement();
            if (!classname.startsWith(packageName)) continue;
            useSystemFirst = false;
            break;
        }
        Class<?> theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            if (useSystemFirst) {
                try {
                    theClass = this.findSystemClass(classname);
                    this.project.log("Class " + classname + " loaded from system loader", 4);
                }
                catch (ClassNotFoundException cnfe) {
                    theClass = this.findClass(classname);
                    this.project.log("Class " + classname + " loaded from ant loader", 4);
                }
            } else {
                try {
                    theClass = this.findClass(classname);
                    this.project.log("Class " + classname + " loaded from ant loader", 4);
                }
                catch (ClassNotFoundException cnfe) {
                    theClass = this.findSystemClass(classname);
                    this.project.log("Class " + classname + " loaded from system loader", 4);
                }
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    private String getClassFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private Class getClassFromStream(InputStream stream, String classname) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = -1;
        byte[] buffer = new byte[1024];
        while ((bytesRead = stream.read(buffer, 0, 1024)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClass(classname, classData, 0, classData.length);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        this.project.log("Finding class " + name, 4);
        return this.findClass(name, this.classpath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClass(String name, Path path) throws ClassNotFoundException {
        InputStream stream = null;
        String classFilename = this.getClassFilename(name);
        try {
            try {
                String[] pathElements = path.list();
                int i = 0;
                while (true) {
                    if (i >= pathElements.length || stream != null) {
                        if (stream != null) break;
                        throw new ClassNotFoundException();
                    }
                    File pathComponent = this.project.resolveFile(pathElements[i]);
                    stream = this.getResourceStream(pathComponent, classFilename);
                    ++i;
                }
                Class clazz = this.getClassFromStream(stream, name);
                Object var6_11 = null;
                try {
                    if (stream == null) return clazz;
                    stream.close();
                    return clazz;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return clazz;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ClassNotFoundException();
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
    }

    public AntClassLoader(Project project, Path classpath) {
        this.project = project;
        this.classpath = classpath;
        this.addSystemPackageRoot("java");
        this.addSystemPackageRoot("javax");
    }

    public AntClassLoader(Project project, Path classpath, boolean systemFirst) {
        this(project, classpath);
        this.systemFirst = systemFirst;
    }
}

