/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/server/TestReplication.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2003/12/03 12:48:02 $
 *
 */

package com.postgres.replic.server;

import com.postgres.replic.util.*;
import com.postgres.replic.server.props.*;
import com.postgres.util.config.*;
import com.postgres.replic.util.struct.*;
import com.postgres.util.jdbc.*;

import java.sql.*;
import java.util.*;

public class TestReplication {

	private ServerProps serverProps;

	private static final boolean DEBUG = true;
	private static final boolean CLEAN = true;
	private static final boolean REPLICATE = !CLEAN;


	private String[] commands = {
		"update test set i='Line 110', k=110 where l=100",
		"update test set i='Line 100', k=100 where l=100",
		"insert into test values ('Line 100', 222, 222)",
		"delete from test where l=222",
	};

	public static void main(String[] argv) {
		TestReplication test = new TestReplication();
		test.run();
	}

	private void run() {
		testCaseConfig(); // Always config;
		//testCase1(REPLICATE);
		//testCase2(CLEAN);
		//testCase2(REPLICATE);

	}

	private void testCase1(boolean clean) {
		ConnectionPool masterPool = null;
		ConnectionPool slavePool = null;

		try {
			masterPool = new ConnectionPool();
			slavePool = new ConnectionPool();
			int server = 0;
			masterPool.initialize("MasterPool.cfg");
			System.out.println("TestReplication::run: INITIALIZED Master Pool");

			slavePool.initialize("SlavePool.cfg");
			System.out.println("TestReplication::run: INITIALIZED Slave Pool");


			Rserv rServ = new Rserv();
			if (DEBUG)
				System.out.println("::run: before rServ.init: initialized?: " +
						rServ.initialized());
			Connection masterConnection = masterPool.getConnection();
			rServ.init(masterConnection, slavePool.getConnection(), 0, serverProps);
			rServ.setDebug(DEBUG);
			if (DEBUG)
				System.out.println("::run: after rServ.init: initialized?: " +
						rServ.initialized());

			if (clean) {
				rServ.cleanLog(2);
			} else {
				rServ.replicate();
			}

		} catch (Exception e) {
			System.out.println("TestReplication::run:" + e.toString());
		} finally {
			destroyPool(masterPool);
			destroyPool(slavePool);
		}
	}

	private void testCase2(boolean clean) {
		ConnectionPool masterPool = null;
		ConnectionPool slavePool = null;
		ConnectionPool slavePool2 = null;
		try {
			masterPool = new ConnectionPool();
			slavePool = new ConnectionPool();
			slavePool2 = new ConnectionPool();

			masterPool.initialize("MasterPool.cfg");
			System.out.println("TestReplication::run: INITIALIZED Master Pool");

			slavePool.initialize("SlavePool.cfg");
			System.out.println("TestReplication::run: INITIALIZED Slave Pool-1");

			slavePool2.initialize("SlavePool2.cfg");
			System.out.println("TestReplication::run: INITIALIZED Slave Pool-2");

			int server = 0;
			int server2 = 1;


			Rserv rServ = new Rserv();
			if (DEBUG)
				System.out.println("::run: before rServ.init: initialized?: " +
						rServ.initialized());

			Connection masterConnection = masterPool.getConnection();
			rServ.init(masterConnection, slavePool.getConnection(), 0, serverProps);
			rServ.setDebug(DEBUG);
			if (DEBUG)
				System.out.println("::run: after rServ.init: initialized?: " +
						rServ.initialized());
			rServ.replicate();

			System.out.println("************************************************");
			rServ.init(masterConnection, slavePool2.getConnection(), 1, serverProps);
			if (DEBUG)
				System.out.println("::run: after 2-nd rServ.init: initialized?: " +
						rServ.initialized());

			if (clean) {
				rServ.cleanLog(2);
			} else {
				rServ.replicate();
			}

		} catch (Exception e) {
			System.out.println("TestReplication::run:" + e.toString());
		} finally {
			destroyPool(masterPool);
			destroyPool(slavePool);
			destroyPool(slavePool2);
		}
	}

	private void testCaseConfig() {
		try {
			ConfiguratorIntf config = ReplicationConfig.getInstance();
			//config.initialize("replication.cfg");
			config.initialize(); // use default config file "replication.cfg"
			config.printProps(null);

			ConnectionPoolProps cPoolProps =
					new ConnectionPoolProps(config, true);
			cPoolProps.printMasterProps();
			cPoolProps.printSlaveProps();

			serverProps = new ServerProps(config, false);
			serverProps.printProperties();

		} catch (Exception e) {
			System.out.println("TestReplication::testCaseConfig:" + e.toString());
		} finally {

		}
	}

	private void runCommand(Connection conn, String sql) throws Exception {
		ResultSet rs = null;
		Statement stmt = null;

		try {
			stmt = conn.createStatement();
			if (DEBUG) System.out.println("::runCommand: Executing command sql=" + sql);
			stmt.executeUpdate(sql);
		} catch (Exception e) {
			throw new Exception("::runCommand: " + e.toString());
		} finally {
			generalClose(stmt, null);
		}
	}

	protected void generalClose(Statement stmt, ResultSet rs) {
		try {
			if (stmt != null) {
				stmt.close();
			}
		} catch (Exception e) {
		}

		try {
			if (rs != null) {
				rs.close();
			}
		} catch (Exception e) {
		}
	}


	private void destroyPool(ConnectionPool cPool) {
		try {
			cPool.destroy();
		} catch (Exception e) {
		}
	}
}
