#!/usr/local/bin/perl
#
# cafHPRIM 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdHPRIM;
 
#@ISA = (cafDBI);
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdHPRIM::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
	my %hprim_attrs = (
		record_tag       => $db->{_ATTRS}{RECORD_TAG},
		rootname         => $db->{_ATTRS}{ROOTNAME},
	);
	foreach my $a (keys %hprim_attrs) {
		if (($hprim_attrs{$a} !~ /^\\$/) and defined($hprim_attrs{$a})) { eval "\$hprim_attrs{$a} = \"$hprim_attrs{$a}\""; }
	}
	$self->{_HPRIM_ATTRS} = \%hprim_attrs;
	$self->{dbh}       = DBI->connect("dbi:AnyData(RaiseError=>1):");
	$! = "";
	$self;
}

sub hprimattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_HPRIM_ATTRS}{$attrib} = shift; }
	$self->{_HPRIM_ATTRS}{$attrib};
}
		
sub hpriminfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_HPRIMINFO}{$infolabel} = shift; }
	$self->{_HPRIMINFO}{$infolabel};
}

sub clearhpriminfo {
	my $self = shift;

	$self->{_HPRIMINFO} = undef;
	delete $self->{_HPRIMINFO};
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->hpriminfo("_NAME")) {

		my ($cmd, $mode, $ad_mode);
		my $qText = $q->query();
		if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
		#elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "w" }
		#elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "w" }
		#elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "w" }
		else { die "Unsuported sql command $cmd"; }

		$q->_attribute("command", $cmd);
		my $db = $self->{db};
		my $container = $self->{db}{container};
		my $name = $container->{name};
		my $externalname = $container->{externalname};
		my @acol_names = map { $_->{name} }  @{$container->{_FIELDS} };

		my $sepDef = undef;
		if ($db->{_ATTRS}{HPRIM_MAINSEP}) {
			$sepDef = {
				sep0 => $db->{_ATTRS}{HPRIM_MAINSEP},
				sep1 => $db->{_ATTRS}{HPRIM_SUBSEP},
				sep2 => $db->{_ATTRS}{HPRIM_SUBSUBSEP},
				esc  => $db->{_ATTRS}{HPRIM_ESCAPE},
				rep  => $db->{_ATTRS}{HPRIM_REPEAT},
			};
			foreach my $k (%$sepDef) {
				if ($sepDef->{$k} =~ /\\/) { $sepDef->{$k} = eval "$sepDef->{$k}"; }
			}
		}
		
		my $dbh = $self->{dbh};

		my $tempfile = $self->getfile({ fname => $externalname, mode => "r" });
		open HPRIM, "<", $tempfile;
		my @lines = <HPRIM>;
		close HPRIM;
		unlink $tempfile;

		my $data = { lines => \@lines, sepDef => $sepDef};
		$self->hpriminfo("_TEMPFILE", $tempfile);
		my $rows = $self->preprepare($data, \@acol_names);
		my $tmp = shift (@$rows);
		@acol_names = @{$tmp || []};
		my $scol_names = join(',', @acol_names);
		$self->hpriminfo("_DATA", $rows);
		$self->hpriminfo("_NAME", $name);
		$self->hpriminfo("_MODE", $mode);
		$self->hpriminfo("_CMD", $cmd);
		$self->hpriminfo("_EXTERNALNAME", $externalname);
		$self->hpriminfo("_SCOLNAMES", $scol_names);
		$self->hpriminfo("_ACOLNAMES", \@acol_names);

		$dbh->func($self->hpriminfo("_NAME"), 'ARRAY', $self->hpriminfo("_DATA"), {col_names => $self->hpriminfo("_SCOLNAMES")}, 'ad_catalog'); 
	}
	return $self->SUPER::prepare($q);
}

#0 = non rpt
#1 = rpt
my %hprimStructs = ( # FIELD LABEL => [ REPEATED?, SUBFIELDS#, [ SUBSUBFIELD#, SUBSUBFIELD#, ... ]
	H_7_5        => [ 0, 2 ],
	H_7_10       => [ 0, 2 ],
	H_7_13       => [ 0, 2 ],
	P_8_3        => [ 0, 3 ],
	P_8_5        => [ 0, 2 ],
	P_8_6        => [ 0, 6 ],
	P_8_11       => [ 0, 6 ], 
	P_8_14       => [ 0, 2 ],
	H_7_8        => [ 1, 2 ],
	P_8_13       => [ 1, 2 ],
	P_8_14       => [ 1, 3, [ 1, 6, 1] ],
	P_8_19       => [ 1, 6 ],
	P_8_20       => [ 1, 1 ],
	P_8_24       => [ 1, 3 ],
	P_8_26       => [ 0, 8 ],
	P_8_27       => [ 0, 6 ],
	OBR_9_3      => [ 0, 2 ],
	OBR_9_4      => [ 0, 2 ],
	OBR_9_5      => [ 1, 6 ],
	OBR_9_8      => [ 1, 1 ],
	OBR_9_16     => [ 0, 3, [ 1, 3, 1 ] ],
	OBR_9_17     => [ 0, 6 ],
	OBR_9_18     => [ 1, 1 ],
	OBR_9_25     => [ 0, 2 ],
	OBR_9_29     => [ 2, 3 ],
	OBR_9_30     => [ 0, 4 ],
	OBR_9_32     => [ 1, 6 ],
	OBR_9_33     => [ 0, 3 ],
	OBR_9_34     => [ 0, 3 ],
	OBR_9_35     => [ 0, 3 ],
	OBR_9_36     => [ 0, 3 ],
	OBX_10_3     => [ 0, 6 ],
	OBX_10_4     => [ 0, 6 ],
	OBX_10_7     => [ 0, 6 ],
	OBX_10_8     => [ 1, 1 ],
	OBX_10_9     => [ 1, 1 ],
	OBX_10_16    => [ 0, 6 ],
	OBX_10_17    => [ 0, 6 ],
	C_12_3       => [ 0, 6 ],
	FAC_20_6     => [ 0, 3 ],
	FAC_20_7     => [ 0, 3 ],
	ACT_21_9     => [ 0, 3 ],
	ACT_21_10    => [ 1, 3 ],
	REG_22_4     => [ 0, 2 ],
	ERR_25_5     => [ 0, 6 ],
	ERR_25_7     => [ 0, 3, [ 1, 1, 3 ] ],
);

my %hprimField;

sub InitHprimField {
	%hprimField = ( hash => { "MSGTYPE" => 1, "SEGTYPE" => 1, "SEGCOMMENTS" => 1 }, array => ["MSGTYPE", "SEGTYPE", "SEGCOMMENTS"], i => 3);
}

my %hprimSegs = ( # SEGMENT LABEL => [ SEGMENT NUM, FIELDS COUNT ]
        H   => [  7, 14 ],
        P   => [  8, 34 ],
        OBR => [  9, 37 ],
        OBX => [ 10, 17 ],
        C   => [ 12,  4 ],
        L   => [ 14,  6 ],
        FAC => [ 20,  8 ],
        ACT => [ 21, 11 ],
        REG => [ 22,  8 ],
        AP  => [ 23, 23 ],
        AC  => [ 24,  7 ],
        ERR => [ 25, 11 ],
        );

my %hprimMsgs = (
	ORM => [ 'H', 'P', 'OBR', 'OBX' ], # 'L' ] # Message demandes d'analyse ou d'actes de radiologie ORM 
	ORU => [ 'H', 'P', 'OBR', 'OBX' ], # 'L' ] # Message rsultats d'analyse ou compte rendu de radiologie de patients ORU 
	ADM => [ 'H', 'P', 'API', 'AC' ], # 'L' ]  # Message de donnes d'admission 
	FAC => [ 'H', 'P', 'API', 'AC', 'FAC', 'REG', 'ACT' ], # 'L' ] # Message de donnes de FACturation 
	REG => [ 'H', 'P', 'REG' ], # 'L' ]        # Message de donnes de REGlemenl 
	ERR => [ 'H', 'ERR' ], # 'L' ]             # Message d'erreur 
);

my $sepDef;

sub nexttoken {
	my $token = shift;

	$token->{i} ||= 0;
	$token->{chunk} = "";
	$token->{l} ||= length($token->{str});
	return undef unless ($token->{i} < $token->{l});
	while ($token->{i} < $token->{l}) {
		my $c = substr($token->{str}, $token->{i}, 1);
		$token->{i} += 1;
		if ($c eq $token->{esc}) {
			$token->{chunk} .= $c . substr($token->{str}, $token->{i}, 1);
			$token->{i} += 1;
		}
		elsif ($c eq $token->{sep}) {
			last;
		}
		else { $token->{chunk} .= $c; }
	}
	return 1;
}

sub addfield {
	my $fName = shift;
	unless ($hprimField{hash}{$fName}) {
		$hprimField{i} += 1;
		$hprimField{hash}{$fName} = $hprimField{i};
		push @{$hprimField{array}}, $fName;
	}
}

sub subf {
	my ($str, $fName, $sepDef, $sep1, $sep2) = @_;
	my $row = {};
	my $tokens = { str => $str, sep => $sepDef->{$sep1}, esc => $sepDef->{esc} };
	my $iTok = 1;

	while (nexttoken($tokens)) {
		my $sfName = $fName . "_" . $iTok;
		$row->{$sfName} = $tokens->{chunk};
		my $subFields = $hprimStructs{$fName}[2];
		if ($sep2 && $subFields && $subFields->[$iTok - 1] > 1) {
			my $r = subf ($row->{$sfName}, $sfName, $sep2);
			foreach my $e (keys %$r) { $row->{$e} = $r->{$e}; }
		}
		$iTok++;
	}
	return $row;
}

sub repeatf {
	my ($row, $fName, $sepDef) = @_;
	my $tokens = { str => $row->{$fName}, sep => $sepDef->{rep}, esc => $sepDef->{esc} };

	my $iTok = 1;
	while (nexttoken($tokens)) {
		my $tokName = $fName . "__" . $iTok;
		if ($row->{$tokName} = $tokens->{chunk}) {
			if ($hprimStructs{$fName}->[1] > 1) {
				my $r = subf($row->{$tokName}, $fName, $sepDef, "sep1", "sep2");
					foreach my $e (keys %$r) { my $t = "$e\__$iTok"; $row->{$t} = $r->{$e}; addfield($t); }
			}
		}
		$iTok++;
	}
}

sub splitf {
	my ($str, $sepDef) = @_;

	my $l = length($str);
	my @f = ();
	my $chunk = "";
	my $ichunk = 1;
	my $sep;
	my $segnum;
	my $segtype;
	my %row;
	if (substr($str, 0, 1) eq 'H') { #H|^~\&|
		$sepDef->{sep0} = substr($str,1,1);
		$sepDef->{sep1} = substr($str,2,1);
		$sepDef->{rep} = substr($str,3,1);
		$sepDef->{esc} = substr($str,4,1);
		$sepDef->{sep2} = substr($str,5,1);
	}
	my $tokens = { str => $str, sep => $sepDef->{sep0}, esc => $sepDef->{esc} };
	while (nexttoken($tokens)) {
		$chunk = $tokens->{chunk};
		if ($#f <= -1) {
			$segtype = $chunk;
			$row{hprimSegNum} = $hprimSegs{$chunk}[0];
			$row{hprimSegTyp} = $chunk;
			$row{hprimSegNam} = $chunk . "_" . $hprimSegs{$chunk}[0] . "_";
		}
		$f[ $#f+1 ] = "$chunk";
	}

	if ($segtype eq 'H') {
		$sepDef->{hprimMsgTyp} = $f[6];
	}

	if ($segtype eq 'P') {
		$sepDef->{PsegCount} += 1;
	}

	if ($segtype eq 'L') {
		$sepDef->{LPsegCount} = $f[3];
		$sepDef->{LsegCount} = $f[4];
		$sepDef->{LlotNumber} = $f[5];
	}

	for (my $i = 0; $i <= $#f; $i++) {
		my $fName = $row{hprimSegNam} . ($i+1);
		addfield($fName) unless ($segtype eq 'L');
		$row{hash}{$fName} = $f[$i];
		if (my $sub = $hprimStructs{$fName}) {
			if ($sub->[0]) { repeatf($row{hash}, $fName, $sepDef); }
			else {
				my $r = subf ($row{hash}{$fName}, $fName, $sepDef, "sep1", "sep2");
				foreach my $e (keys %$r) { $row{hash}{$e} = $r->{$e}; addfield($e)}
			}
		}
	} 
	return \%row;
}

sub HprimMt {
	my $Mt = shift;
	return $hprimMsgs{$Mt} || [];
}

sub GetTableKinds {
	my @ret;
	@ret = map +{ "kind", $_ }, keys %hprimMsgs;
	return \@ret;
}

sub GetTableDef {
	my $Mt = shift;

	my @F;
	foreach my $St (@{HprimMt($Mt)}) {
		for (my $i = 1; $i <= $hprimSegs{$St}[1]; $i++) {
			$F[$#F+1] = "$St\_$hprimSegs{$St}[0]_$i"
		}
	}

	unshift @F, "MSGTYPE", "SEGTYPE";
	return \@F;
}

sub preprepare {
	my $self = shift;
	my $data = shift; # sepDef; arrayOfLines; return arrayOfRows
	my $colnames = shift;

	my $lines = $data->{lines};
	$sepDef = $data->{separators};
	$sepDef->{segCount} = $#$lines + 1;
	$sepDef->{PsegCount} = 0;
	
	my @parsed;

	$self->InitHprimField();
	for (my $i; $i <= $#$lines; $i++) {
		my $s;
		$s = $lines->[$i];
		if ( $sepDef->{sep0} ) {
			my $Conitnue = "A$sepDef->{sep0}";
			while (substr($lines->[$i+1], 0, 2) eq $Conitnue) {
				$s .= substr($lines->[$i+1], 2);
				$i++;
			}
		}
		$s=~s/[\r\n]//gm;
		my $r = splitf($s, $sepDef);
		push @parsed, $r;
	}

	my $segTypes = HprimMt ($sepDef->{hprimMsgTyp});
	my $level = 0;
	my @parents;
	my @rows;
	push @rows, $hprimField{array};

	foreach my $r (@parsed) {
		my $found = 0;
		my @row;
		if ($r->{hprimSegTyp} eq 'C') {
			if ($#rows >= 0) {
				$rows[$#rows][2] .= $sepDef->{sep0} if ($rows[$#rows][2]);
				$rows[$#rows][2] .= $r->{hash}{C_12_4};
			}
			next;
		}
		if ($r->{hprimSegTyp} ne $segTypes->[$level]) {
			for (my $i = $level + 1; $i <= $#$segTypes; $i++) {
				if ($r->{hprimSegTyp} eq $segTypes->[$i]) {
					$found = 1;
					$level = $i;
					push @parents, $r;
					last;
				}
			}
			unless ($found) {
				for (my $i = $level; $i >= 0; $i--) {
					if ($r->{hprimSegTyp} eq $segTypes->[$i]) {
						$found = 1;
						$level = $i;
						last;
					}
					else { pop @parents; }
				}
				pop @parents; push @parents, $r;
			}
		}
		else { $found = 1; pop @parents; push @parents, $r}
		if ($found) {
			for (my $i = 0; $i <= $#parents; $i++) {
				my $r2 = $parents[$i];
				foreach my $fName (keys %{$r2->{hash}}) {
					$row[ $hprimField{hash}{$fName} - 1 ] = $r2->{hash}{$fName};
				}
			}
			$row[0] = $sepDef->{hprimMsgTyp};
			$row[1] = $r->{hprimSegTyp};
			push @rows, \@row;
		}
	}

	$data->{hprimMsgTyp} = $sepDef->{hprimMsgTyp};
	foreach my $col (@{$colnames || []}) { addfield($col); }
	$rows[0] =  $hprimField{array};
	$data->{rows} = \@rows;
	return \@rows;
}


=cut

	open I, "/home/aliphe/HPRIM/HPRIMFILES/270105.ok";
	my @l = <I>;
	close I;
	my $rows = preprepare ({lines=>\@l, sepDef=>{}}); 
	print "LINES $#$rows\n";

use Data::Dumper;
#$Data::Dumper::Indent = 1;

	print Dumper $sepDef;
	print Dumper $rows;
	my $desc = GetTableDef($ARGV[0]);

	print "Fields Count $ARGV[0] : $#$desc\n";
	print Dumper $desc;

=cut





sub setexternalname {
	my $self = shift;
	my $filename = shift;
	my $container = $self->{db}{container};
	$container->{externalname} = $filename;

	$self->hpriminfo("_EXTERNALNAME", $filename) if ($self->hpriminfo("_EXTERNALNAME"));
}

sub getexternalname {
	my $self = shift;
	my $container = $self->{db}{container};

	$self->hpriminfo("_EXTERNALNAME") || $container->{externalname};
}


sub finalrollback {
	my $self = shift;

	return 1 unless $self->hpriminfo("_NAME");
	$self->clearhpriminfo();
	1;
}

sub finalcommit {
	my $self = shift;

	return 1 unless $self->hpriminfo("_NAME");
	$self->clearhpriminfo();
	1;
}

sub describe {
	my $self = shift;
	my $table_name = shift;
	shift;
	shift;
	my $tablekind = shift;


	$table_name =~ /^([[:alpha:]][[:alpha:]][[:alpha:]])/;
	$tablekind ||= $1;
	my $TYPE = $hprimMsgs{$tablekind||"NOTHING"} ? $tablekind : "ORU";

	my $fields = GetTableDef($TYPE);

	my (@ret, $i);
	foreach my $e (@$fields) {
		$i++;
		push @ret, {
				name => $e,
				externalname => $e,
				datatypeid => 'VARCHAR',
				datalength => 100,
				fieldorder => $i*10,
				keyposition  => ($i > 3) ? undef : $i,
		};
	}

	\@ret;
}

sub generatequery {
	my $self = shift;

	@cafdHPRIM::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

1;
