#!/usr/local/bin/perl
#
# cafdFLR 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdFLR;
 
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdFLR::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
	my %flr_attrs = (
		record_tag       => $db->{_ATTRS}{RECORD_TAG},
	);
	foreach my $a (keys %flr_attrs) {
		if (($flr_attrs{$a} !~ /^\\$/) and defined($flr_attrs{$a})) { eval "\$flr_attrs{$a} = \"$flr_attrs{$a}\""; }
	}
	$self->{_FLR_ATTRS} = \%flr_attrs;
	$self->{dbh}       = DBI->connect("dbi:AnyData(RaiseError=>1):");
	$self;
}

sub flrattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_FLR_ATTRS}{$attrib} = shift; }
	$self->{_FLR_ATTRS}{$attrib};
}
		
sub flrinfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_FLRINFO}{$infolabel} = shift; }
	$self->{_FLRINFO}{$infolabel};
}

sub clearflrinfo {
	my $self = shift;

	$self->{_FLRINFO} = undef;
	delete $self->{_FLRINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "w" }
	elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "w" }
	elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "w" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};

	my $pattern;
	my $sep = "";
	my $ftype = "A";
	foreach my $col (@{$container->{_FIELDS}}) {
		$pattern .= "$sep$ftype" . $col->{datalength};
		$sep=" ";
	}

	my @acol_names = map { $_->{name} }  @{$container->{_FIELDS}};
	my $scol_names = join(',', @acol_names);

	my $name = $container->{name};
	my $externalname = $container->{externalname};

	$self->flrinfo("_NAME", $name);
	$self->flrinfo("_MODE", $mode);
	$self->flrinfo("_CMD", $cmd);
	$self->flrinfo("_EXTERNALNAME", $externalname);
	$self->flrinfo("_SCOLNAMES", $scol_names);
	$self->flrinfo("_ACOLNAMES", \@acol_names);
	$self->flrinfo("_PATTERN", $pattern);
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->flrinfo("_NAME")) {
		$self->preprepare($q);
		my ($cmd, $mode) = ($self->flrinfo($q, "_CMD"),$self->flrinfo("_MODE"));

		my $dbh = $self->{dbh};

		my $tempfile = $self->getfile({ fname => $self->flrinfo("_EXTERNALNAME"), mode => $mode });
		$self->flrinfo("_TEMPFILE", $tempfile);
		my $ad_flags = {
			col_names => $self->flrinfo("_SCOLNAMES"),
			pattern => $self->flrinfo("_PATTERN"),
		};
#		print "colnames = $ad_flags->{col_names} | pattern = $ad_flags->{pattern}\n";
		$dbh->func($self->flrinfo("_NAME"), 'Fixed', $tempfile, $ad_flags,  'ad_catalog'); 
	}
	return $self->SUPER::prepare($q);
}

sub setexternalname {
	my $self = shift;
	my $filename = shift;
	my $container = $self->{db}{container};
	$container->{externalname} = $filename;

	$self->flrinfo("_EXTERNALNAME", $filename) if($self->flrinfo("_EXTERNALNAME"));
}

sub getexternalname {
	my $self = shift;
	my $container = $self->{db}{container};
	$self->flrinfo("_EXTERNALNAME") || $container->{externalname};
}


sub finalcommit {
	my $self = shift;

	return 1 unless $self->flrinfo("_NAME");
	if ($self->flrinfo("_CMD") ne "select") {
		my $tempfile = $self->flrinfo("_TEMPFILE");
		$self->protocommit($tempfile, $self->flrinfo("_EXTERNALNAME"));
	}
	$self->clearflrinfo();
}

sub finalrollback {
	my $self = shift;

	return 1 unless $self->flrinfo("_NAME");
	my $tempfile = $self->flrinfo("_TEMPFILE");
	$self->protorollback($tempfile);
	$self->clearflrinfo();
}

sub generatequery {
	my $self = shift;

	@cafdFLR::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}
1;
